/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 16:40:20 EDT
 */

package org.gnu.gdk;
import org.gnu.glib.GObject;
/**
 *
 */
public class Pixbuf extends GObject {
	/**
	 * Constructs a Pixbuf from a handle to native resources. This should only
	 * be used internally by java-gnome.
	 */
	public Pixbuf(int handle) {
		this.handle = handle;
	}

	/**
	 * Construct a new Pixbuf from an image file.
	 * @param filename The name of the image file.
	 */
	public Pixbuf(String filename) {
		int error = 0;
		handle = gdk_pixbuf_new_from_file(filename, error);
	}

	/**
	 * Return the width of the pixbuf.
	 * @return The width
	 */
	public int width() {
		return gdk_pixbuf_get_width(handle);
	}

	/**
	 * Return the height of the pixbuf.
	 * @return The height
	 */
	public int height() {
		return gdk_pixbuf_get_height(handle);
	}

	/**
	 * Create a new pixbuf from an existing pixbuf scaled to the
	 * size provided.
	 */
	public Pixbuf scale(int width, int height, org.gnu.gdk.InterpType itype) {
		int newH = gdk_pixbuf_scale_simple(handle, width, height, itype.getValue());
		return new Pixbuf(newH);
	}
	
	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected void gdk_pixbuf_render_threshold_alpha(
		int pixbuf,
		int bitmap,
		int srcX,
		int srcY,
		int destX,
		int destY,
		int width,
		int height,
		int alphaThreshold);
	native static final protected void gdk_pixbuf_render_to_drawable(
		int pixbuf,
		int drawable,
		int gc,
		int srcX,
		int srcY,
		int destX,
		int destY,
		int width,
		int height,
		int dither,
		int xDither,
		int yDither);
	native static final protected void gdk_pixbuf_render_to_drawable_alpha(
		int pixbuf,
		int drawable,
		int srcX,
		int srcY,
		int destX,
		int destY,
		int width,
		int height,
		int alphaMode,
		int alphaThreshold,
		int dither,
		int xDither,
		int yDither);
	native static final protected void gdk_pixbuf_render_pixmap_and_mask_for_colormap(
		int pixbuf,
		int colormap,
		int pixmapReturn,
		int maskReturn,
		int alphaThreshold);
	native static final protected void gdk_pixbuf_render_pixmap_and_mask(
		int pixbuf,
		int pixmapReturn,
		int maskReturn,
		int alphaThreshold);
	native static final protected int gdk_pixbuf_get_from_drawable(
		int dest,
		int src,
		int cmap,
		int srcX,
		int srcY,
		int destX,
		int destY,
		int width,
		int height);
	native static final protected int gdk_pixbuf_get_from_image(
		int dest,
		int src,
		int cmap,
		int srcX,
		int srcY,
		int destX,
		int destY,
		int width,
		int height);
	native static final protected int gdk_pixbuf_get_colorspace(int pixbuf);
	native static final protected int gdk_pixbuf_get_n_channels(int pixbuf);
	native static final protected boolean gdk_pixbuf_get_has_alpha(int pixbuf);
	native static final protected int gdk_pixbuf_get_bits_per_sample(int pixbuf);
	native static final protected byte[] gdk_pixbuf_get_pixels(int pixbuf);
	native static final protected int gdk_pixbuf_get_width(int pixbuf);
	native static final protected int gdk_pixbuf_get_height(int pixbuf);
	native static final protected int gdk_pixbuf_get_rowstride(int pixbuf);
	native static final protected int gdk_pixbuf_new(
		int colorspace,
		boolean hasAlpha,
		int bitsPerSample,
		int width,
		int height);
	native static final protected int gdk_pixbuf_copy(int pixbuf);
	native static final protected int gdk_pixbuf_new_subpixbuf(
		int srcPixbuf,
		int srcX,
		int srcY,
		int width,
		int height);
	native static final protected int gdk_pixbuf_new_from_file(String filename, int error);
	native static final protected int gdk_pixbuf_new_from_xpm_data(byte[] data);
	native static final protected int gdk_pixbuf_new_from_inline(
		int dataLength,
		byte[] data,
		boolean copyPixels,
		int error);
	native static final protected void gdk_pixbuf_fill(int pixbuf, int pixel);
	native static final protected int gdk_pixbuf_add_alpha(int pixbuf, boolean substituteColor, int r, int g, int b);
	native static final protected void gdk_pixbuf_copy_area(
		int srcPixbuf,
		int srcX,
		int srcY,
		int width,
		int height,
		int destPixbuf,
		int destX,
		int destY);
	native static final protected void gdk_pixbuf_saturate_and_pixelate(
		int src,
		int dest,
		double saturation,
		boolean pixelate);
	native static final protected void gdk_pixbuf_scale(
		int src,
		int dest,
		int destX,
		int destY,
		int destWidth,
		int destHeight,
		double offsetX,
		double offsetY,
		double scaleX,
		double scaleY,
		int interpType);
	native static final protected void gdk_pixbuf_composite(
		int src,
		int dest,
		int destX,
		int destY,
		int destWidth,
		int destHeight,
		double offsetX,
		double offsetY,
		double scaleX,
		double scaleY,
		int interpType,
		int overallAlpha);
	native static final protected void gdk_pixbuf_composite_color(
		int src,
		int dest,
		int destX,
		int destY,
		int destWidth,
		int destHeight,
		double offsetX,
		double offsetY,
		double scaleX,
		double scaleY,
		int interpType,
		int overallAlpha,
		int checkX,
		int checkY,
		int checkSize,
		int color1,
		int color2);
	native static final protected int gdk_pixbuf_scale_simple(int src, int destWidth, int destHeight, int interpType);
	native static final protected int gdk_pixbuf_composite_color_simple(
		int src,
		int destWidth,
		int destHeight,
		int interpType,
		int overallAlpha,
		int checkSize,
		int color1,
		int color2);
	native static final protected byte[] gdk_pixbuf_get_option(int pixbuf, byte[] key);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
