/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:35 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * This is a simple arrowhead widget that points up, down, left, or
 * right.
 */
public class Arrow extends Misc 
{
	/**
	 * Construct a new Arrow.
	 */
	public Arrow(ArrowType type, ShadowType shadowType) {
		handle = gtk_arrow_new(type.getValue(), shadowType.getValue());
		initializeEventHandlers();
	}
	
	/**
	 * Construct an Arrow from a handle to a native resource.
	 */
	public Arrow(int handle) {
	    super(handle);
	}
	
	protected void noopInit() {}
	
	/**
	 * Set the values for this Arrow object.
	 */
	public void setValues(ArrowType type, ShadowType shadowType) {
		gtk_arrow_set(handle, type.getValue(), shadowType.getValue());
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_arrow_get_type());
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_arrow_get_type ();
    native static final protected int gtk_arrow_new (int arrowType, int shadowType);
    native static final protected void gtk_arrow_set (int arrow, int arrowType, int shadowType);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

