/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:41 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * MessageDialog presents a dialog with an image representing the type of 
 * message (Error, Question, etc.) alongside some message text. It's simply 
 * a convenience widget; you could construct the equivalent of 
 * MessageDialog from {@link Dialog} without too much effort, but 
 * MessageDialog saves typing.
 *
 * <p>The easiest way to do a modal message dialog is to use {@link #run()}.
 */
public class MessageDialog extends Dialog 
{
	
	/**
	 * Construct a new MessageDialog.
	 * 
	 * @param parent The parent Window of this MessageDialog.
	 * @param flags Provides initialization information for the Dialog.
	 * @param type The type of message to display.  @see MessageType
	 * @param buttons What type of buttons should be on this dialog.
	 * @param message The message to display.
	 */
	public MessageDialog(Window parent, DialogFlags flags, MessageType type, 
						ButtonsType buttons, String message) {
		handle = MessageDialog.gtk_message_dialog_new(parent.getHandle(),
													  flags.getValue(),
													  type.getValue(),
													  buttons.getValue(),
													  message);
		initializeEventHandlers();
	}
	
	/**
	 * Construct a MessageDialog using a handle to a native resource.
	 */
	public MessageDialog(int handle) {
	    super(handle);
	}

	protected void noopInit() {}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_message_dialog_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_message_dialog_get_type ();
    native static final protected int gtk_message_dialog_new (int parent, int flags, int type, int 
        buttons, String messageFormat);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

