/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:38 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * VBox is a container widget that organizes its contained widgets
 * vertically. Most manipulation methods are part of the super class, Box
 * @see Box
 * @see HBox
 */
public class VBox extends Box {
	/**
	 * Constructs a new VBox widget
	 * @param homogenous TRUE if all children are to be given equal space allotments.
	 * @param spacing The  number of pixels to place by default between children.
	 */
	public VBox (boolean homogenous, int spacing) {
		handle = gtk_vbox_new (homogenous, spacing);
		initializeEventHandlers();
	}
	
	/**
	 * Construct a VBox widget from a handle to a native resource.
	 */
	public VBox(int handle) {
	    super(handle);
	}
	
	protected VBox() {}
	
	protected void noopInit() {}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_vbox_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_vbox_get_type ();
    native static final protected int gtk_vbox_new (boolean homogenous, int spacing);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

