/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:35 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * The Frame widget is a Bin that surrounds its child with a decorative
 * frame and an optional label.  If present, the label is drawn in the
 * gap in the top side of the frame by default.
 */
public class Frame extends Bin 
{

	/**
	 * Creates a new frame with no label
	 */
	public Frame(){
		noopInit();
	}
	
	/**
	 * Construct a frame using a handle to a native resource.
	 */
	public Frame(int handle) {
	    super(handle);
	}

	protected void noopInit() {
		if (-1 == handle) {
			handle = gtk_frame_new("");
			initializeEventHandlers();
		}
	}

	/**
	 * Creates a new frame, with the text of label being displayed in the top
	 * left. 
	 * @param label Text to be displayed in the border of the frame.
	 */
	public Frame(String label){
		handle = gtk_frame_new(label);
		initializeEventHandlers();
	}

	/**
	 * Changes the label which is displayed in the frame border.
	 * @param label The text to display
	 */
	public void setLabel(String label){
		gtk_frame_set_label(handle, label);
	}

	/**
	 * Removes the label from the frame
	 */
	public void removeLabel(){
		gtk_frame_set_label(handle, null);
	}

	/**
	 * Returns the text of the label which is being displayed at the top of the
	 * frame.
	 * @return The text of the label for the frame, if any.
	 */
	public String getLabel(){
		return gtk_frame_get_label(handle);
	}

	/**
	 * Sets the widget to use as the label for the frame.
	 * If you want a simple label, use the {@link #setLabel(String)} method
	 * @param labelWidget The widget to use in the label position of the frame.
	 */
	public void setLabelWidget(Widget labelWidget){
		gtk_frame_set_label_widget(handle, labelWidget.getHandle());
	}

	/**
	 * Returns the widget being used as the label of the frame. If the frame has
	 * just been constructed with a label string, then this will be a {@link
	 * Label} widget. This method allows you to customise the widget.
	 * @return The widget currently being used as the label.
	 */
	public Widget getLabelWidget(){
		return new Widget( gtk_frame_get_label_widget(handle) );
	}

	// TODO? Change the following to use different parameters?
	/**
	 * Sets the alignment of the label widget along the top edge of the frame. 
	 * A vale of 0.0 means full left align; 0.5 means centered; 1.0 is full
	 * right align
	 * @param align A number representing the alignment of the label.
	 */
	public void setLabelAlign( double align ){
		// Y-Align is currently unimplemnted in gtk.
		gtk_frame_set_label_align(handle, align, 0);
	}

	/**
	 * Returns a number representing the alignment of the label
	 * @see #setLabelAlign(double)
	 * @return The alignment of the label on the top of the frame.
	 */
	public double getLabelAlign(){
		double[] x = new double[1];
		double[] y = new double[1];
		gtk_frame_get_label_align(handle, x, y);
		return x[0];
	}
	
	/**
	 * Sets the {@link ShadowType} to be displayed for the frame.
	 * @param shadowType the shadow type to be used.
	 */
	public void setShadow( ShadowType shadowType){
		gtk_frame_set_shadow_type(handle, shadowType.getValue() );
	}

	/**
	 * Returns the shadow type in use
	 * @return shadowType the shadow tyoe being displayed
	 */
	public ShadowType getShadow(){
		return ShadowType.intern( gtk_frame_get_shadow_type(handle) );
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_frame_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_frame_get_type ();
    native static final protected int gtk_frame_new (String label);
    native static final protected void gtk_frame_set_label (int frame, String label);
    native static final protected String gtk_frame_get_label (int frame);
    native static final protected void gtk_frame_set_label_widget (int frame, int labelWidget);
    native static final protected int gtk_frame_get_label_widget (int frame);
    native static final protected void gtk_frame_set_label_align (int frame, double xalign, double 
        yalign);
    native static final protected void gtk_frame_get_label_align (int frame, double [] xalign, 
        double [] yalign);
    native static final protected void gtk_frame_set_shadow_type (int frame, int type);
    native static final protected int gtk_frame_get_shadow_type (int frame);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

