/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:32 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * This is a base class providing allignment and padding to a number of
 * displayable widgets.
 */
public class Misc extends Widget {

        protected Misc() {}

        protected Misc(int handle) {
	    super(handle);
	}

	protected void noopInit() {
	}

	/**
	 * Sets the alignment of a widget.
	 * @param xAlign The horizontal alignment from 0 (left) to 1 (right).
	 * @param yAlign The vertical alignment from 0 (top) to 1 (bottom).
	 */
	public void setAlignment(double xAlign, double yAlign) {
		Misc.gtk_misc_set_alignment(handle, xAlign, yAlign);
	}

	/**
	 * Returns the horizontal alignment of the widget.
	 */
	public double getXAlign() {
		double[] xAlign = new double[1];
		double[] yAlign = new double[1];
		Misc.gtk_misc_get_alignment(handle, xAlign, yAlign);
		return xAlign[0];
	}

	/**
	 * Returns the vertical alignment of the widget.
	 */
	public double getYAlign() {
		double[] xAlign = new double[1];
		double[] yAlign = new double[1];
		Misc.gtk_misc_get_alignment(handle, xAlign, yAlign);
		return yAlign[0];
	}

	/**
	 * Sets the amount of space to add around the widget.
	 * @param xPad The amount of space to add to the left and right of the widget.
	 * @param yPad The amount of space to add to the top and bottom of the widget.
	 */
	public void setPadding(int xPad, int yPad) {
		Misc.gtk_misc_set_padding(handle, xPad, yPad);
	}

	/**
	 * Retrieve the amount of space added to the left and right of the widget.
	 */
	public int getXPadding() {
		int[] xPad = new int[1];
		int[] yPad = new int[1];
		Misc.gtk_misc_get_padding(handle, xPad, yPad);
		return xPad[0];
	}

	/**
	 * Retrieve the amount of space added to the top and bottom of the widget.
	 */
	public int getYPadding() {
		int[] xPad = new int[1];
		int[] yPad = new int[1];
		Misc.gtk_misc_get_padding(handle, xPad, yPad);
		return yPad[0];
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_misc_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_misc_get_type();
	native static final protected void gtk_misc_set_alignment(int misc, double xalign, double yalign);
	native static final protected void gtk_misc_get_alignment(int misc, double[] xalign, double[] yalign);
	native static final protected void gtk_misc_set_padding(int misc, int xpad, int ypad);
	native static final protected void gtk_misc_get_padding(int misc, int[] xpad, int[] ypad);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
