/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:40 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * The VScrollbar displays a vertical scrollbar with a slider and a
 * pair of arror buttons. To create a scrollbar, you must specify the
 * beginning and ending values, the size of the slider, an initial
 * slider position, and how far the slider should move when the mouse
 * clicks the slot.
 * @see HScrollBar
 */
public class VScrollBar extends ScrollBar 
{
	/**
	 * Creates a new ScrollBar
	 * @param adjustment The GtkAdjustment to use, or NULL to create 
	 * a new adjustment.
	 */
	public VScrollBar( Adjustment adjustment ){
		handle = gtk_vscrollbar_new( adjustment.getHandle() );
		initializeEventHandlers();
	}
	
	/**
	 * Construct a VScrollBar from a handle to a native resource.
	 */
	public VScrollBar(int handle) {
	    super(handle);
	}
	
	protected void noopInit() {}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_vscrollbar_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_vscrollbar_get_type ();
    native static final protected int gtk_vscrollbar_new (int adjustment);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

