/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:34 EDT
 */

package org.gnu.gtk;
import org.gnu.glib.GObject;
import org.gnu.glib.Type;
import org.gnu.pango.Weight;
import org.gnu.pango.Style;
import org.gnu.pango.Scale;
import org.gnu.pango.Underline;
/**
 * See the {@link TextBuffer} description for an overview of these classes.
 * <p>TextTags should be created using the {@link TextBuffer#createTag(String)}
 * method.
 */
public class TextTag extends GObject 
{
	protected TextTag(int handle){
		this.handle = handle;
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_text_tag_get_type());
	}

	/**
	 * Returns the name of the tag
	 */
	public String getName(){
		return getName(handle);
	}

	/**
	 * Sets the priority of the Tag. Valid priorities are start at 0 and go to
	 * one less than {@link TextTagTable.getSize()}. Each tag in a table has a
	 * unique priority; setting the priority of one tag shifts the priorities of
	 * all the other tags in the table to maintain a unique priority for each
	 * tag. Higher priority tags "win" if two tags both set the same text
	 * attribute. When adding a tag to a tag table, it will be assigned the
	 * highest priority in the table by default; so normally the precedence of a
	 * set of tags is the order in which they were added to the table, or
	 * created with {@link TextBuffer.createTag(String)}, which adds the tag to
	 * the buffer's table automatically.
	 */
	public void setPriority( int priority ){
		gtk_text_tag_set_priority( handle, priority );
	}

	/**
	 * Returns the priority of the tag.
	 * @see #setPriority(int)
	 */
	public int getPriority(){
		return gtk_text_tag_get_priority( handle );
	}

	public void setSize(int size){
		setIntProperty( handle, "size", size * 1024);
	}
	public void setFamily( String family ){
		setStringProperty( handle, "family", family);
	}
	public void setForeground( String foreground ){
		setStringProperty( handle, "foreground", foreground );
	}
	public void setBackground( String background ){
		setStringProperty( handle, "background", background );
	}
	public void setPixelsAboveLines( int setting ){
		setIntProperty( handle, "pixels_above_lines", setting );
	}
	public void setPixelsBelowLines( int setting ){
		setIntProperty( handle, "pixels_below_lines", setting );
	}
	public void setPixelsInsideWrap( int setting ){
		setIntProperty( handle, "pixels_inside_wrap", setting );
	}
	public void setEditable( boolean editable ){
		setBooleanProperty( handle, "editable", editable );
	}
	public void setStrikethrough( boolean strikethrough ){
		setBooleanProperty( handle, "strikethrough", strikethrough );
	}
	public void setWeight( Weight weight ){
		setIntProperty( handle, "weight", weight.getValue() );
	}
	public void setWrapMode( WrapMode mode ){
		setIntProperty( handle, "wrap_mode", mode.getValue() );
	}
	public void setLeftMargin( int margin ){
		setIntProperty( handle, "left-margin", margin );
	}
	public void setRightMargin( int margin ){
		setIntProperty( handle, "right-margin", margin );
	}
	public void setRise( int rise ){
		setIntProperty( handle, "rise", rise );
	}
	public void setIndent( int indent ){
		setIntProperty( handle, "indent", indent );
	}
	public void setUnderline( Underline underline ){
		setIntProperty( handle, "underline", underline.getValue() );
	}
	public void setJustification( Justification justification ){
		setIntProperty( handle, "justification", justification.getValue() );
	}
	public void setStyle( Style  style){
		setIntProperty( handle, "style", style.getValue() );
	}
	public void setDirection( TextDirection direction){
		setIntProperty( handle, "direction", direction.getValue() );
	}
	public void setScale( Scale scale){
		setDoubleProperty( handle, "scale", scale.getValue() );
	}
//		"background"           gchararray           : Write
//  "background-full-height" gboolean             : Read / Write
//  "background-full-height-set" gboolean             : Read / Write
//  "background-gdk"       GdkColor             : Read / Write
//  "background-set"       gboolean             : Read / Write
//  "background-stipple"   GdkPixmap            : Read / Write
//  "background-stipple-set" gboolean             : Read / Write
//  "direction"            GtkTextDirection     : Read / Write
//  "editable"             gboolean             : Read / Write
//  "editable-set"         gboolean             : Read / Write
//  "family"               gchararray           : Read / Write
//  "family-set"           gboolean             : Read / Write
//  "font"                 gchararray           : Read / Write
//  "font-desc"            PangoFontDescription : Read / Write
//  "foreground"           gchararray           : Write
//  "foreground-gdk"       GdkColor             : Read / Write
//  "foreground-set"       gboolean             : Read / Write
//  "foreground-stipple"   GdkPixmap            : Read / Write
//  "foreground-stipple-set" gboolean             : Read / Write
//  "indent"               gint                 : Read / Write
//  "indent-set"           gboolean             : Read / Write
//  "invisible"            gboolean             : Read / Write
//  "invisible-set"        gboolean             : Read / Write
//  "justification"        GtkJustification     : Read / Write
//  "justification-set"    gboolean             : Read / Write
//  "language"             gchararray           : Read / Write
//  "language-set"         gboolean             : Read / Write
//  "left-margin"          gint                 : Read / Write
//  "left-margin-set"      gboolean             : Read / Write
//  "name"                 gchararray           : Read / Write / Construct Only
//  "pixels-above-lines"   gint                 : Read / Write
//  "pixels-above-lines-set" gboolean             : Read / Write
//  "pixels-below-lines"   gint                 : Read / Write
//  "pixels-below-lines-set" gboolean             : Read / Write
//  "pixels-inside-wrap"   gint                 : Read / Write
//  "pixels-inside-wrap-set" gboolean             : Read / Write
//  "right-margin"         gint                 : Read / Write
//  "right-margin-set"     gboolean             : Read / Write
//  "rise"                 gint                 : Read / Write
//  "rise-set"             gboolean             : Read / Write
//  "scale"                gdouble              : Read / Write
//  "scale-set"            gboolean             : Read / Write
//  "size-points"          gdouble              : Read / Write
//  "size-set"             gboolean             : Read / Write
//  "stretch"              PangoStretch         : Read / Write
//  "stretch-set"          gboolean             : Read / Write
//  "strikethrough"        gboolean             : Read / Write
//  "strikethrough-set"    gboolean             : Read / Write
//  "style"                PangoStyle           : Read / Write
//  "style-set"            gboolean             : Read / Write
//  "tabs"                 PangoTabArray        : Read / Write
//  "tabs-set"             gboolean             : Read / Write
//  "underline"            PangoUnderline       : Read / Write
//  "underline-set"        gboolean             : Read / Write
//  "variant"              PangoVariant         : Read / Write
//  "variant-set"          gboolean             : Read / Write
//  "weight-set"           gboolean             : Read / Write
//  "wrap-mode"            GtkWrapMode          : Read / Write
//  "wrap-mode-set"        gboolean             : Read / Write


	native static final protected void setStringProperty( int handle, String property, String setting );
	native static final protected void setBooleanProperty( int handle, String property, boolean setting );
	native static final protected void setIntProperty( int handle, String property, int setting );
	native static final protected void setDoubleProperty( int handle, String property, double setting );

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected String getName (int cptr);
    native static final protected boolean getBgColorSet (int cptr);
    native static final protected boolean getBgStippleSet (int cptr);
    native static final protected boolean getFgColorSet (int cptr);
    native static final protected boolean getScaleSet (int cptr);
    native static final protected boolean getFgStippleSet (int cptr);
    native static final protected boolean getJustificationSet (int cptr);
    native static final protected boolean getLeftMarginSet (int cptr);
    native static final protected boolean getIndentSet (int cptr);
    native static final protected boolean getRiseSet (int cptr);
    native static final protected boolean getStrikethroughSet (int cptr);
    native static final protected boolean getRightMarginSet (int cptr);
    native static final protected boolean getPixelsAboveLinesSet (int cptr);
    native static final protected boolean getPixelsBelowLinesSet (int cptr);
    native static final protected boolean getPixelsInsideWrapSet (int cptr);
    native static final protected boolean getTabsSet (int cptr);
    native static final protected boolean getUnderlineSet (int cptr);
    native static final protected boolean getWrapModeSet (int cptr);
    native static final protected boolean getBgFullHeightSet (int cptr);
    native static final protected boolean getInvisibleSet (int cptr);
    native static final protected boolean getEditableSet (int cptr);
    native static final protected boolean getLanguageSet (int cptr);
    native static final protected boolean getPad1 (int cptr);
    native static final protected boolean getPad2 (int cptr);
    native static final protected boolean getPad3 (int cptr);
    native static final protected int gtk_text_tag_get_type ();
    native static final protected int gtk_text_tag_new (String name);
    native static final protected int gtk_text_tag_get_priority (int tag);
    native static final protected void gtk_text_tag_set_priority (int tag, int priority);
    native static final protected boolean gtk_text_tag_event (int tag, int eventObject, int event, 
        int iter);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

