/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

/**
 */
public class SeparatorToolItem extends ToolItem {
	
	public SeparatorToolItem() {
		if (-1 == getHandle())
			setHandle(gtk_separator_tool_item_new());
		initializeEventHandlers();
	}
	
	public SeparatorToolItem(int hndl) {
		setHandle(hndl);
		initializeEventHandlers();
	}
	
	/**
	 * Sets whether the SeparatorToolItem is drawn as a line or just
	 * blank.
	 * @param drawLine
	 */
	public void setDrawLine(boolean drawLine) {
		gtk_separator_tool_item_set_draw(getHandle(), drawLine);
	}
	
	/**
	 * Returns whether the SeparatorToolItem is drawn as a line or
	 * just blank.
	 * @return
	 */
	public boolean getDrawLine() {
		return gtk_separator_tool_item_get_draw(getHandle());
	}

	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gtk_separator_tool_item_get_type();
	native static final protected int gtk_separator_tool_item_new();
	native static final protected boolean gtk_separator_tool_item_get_draw(int item);
	native static final protected void gtk_separator_tool_item_set_draw(int item, boolean draw);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
