/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif

//GtkTreePath * GtkTreeStore_get_root (GtkTreeStore * cptr) 
//{
//    return cptr->root;
//}
//
///*
// * Class:     org.gnu.gtk.TreeStore
// * Method:    getRoot
// * Signature: (I)I
// */
//JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeStore_getRoot (JNIEnv *env, jclass cls, jint cptr) 
//{
//    GtkTreeStore *cptr_g = (GtkTreeStore *)cptr;
//    {
//        return (jint)GtkTreeStore_get_root (cptr_g);
//    }
//}
//
//void GtkTreeStore_set_root (GtkTreeStore * cptr, GtkTreePath * root) 
//{
//    cptr->root = root;
//}
//
///*
// * Class:     org.gnu.gtk.TreeStore
// * Method:    setRoot
// * Signature: (II)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeStore_setRoot (JNIEnv *env, jint cptr, jint root) 
//{
//    GtkTreeStore *cptr_g = (GtkTreeStore *)cptr;
//    GtkTreePath *root_g = (GtkTreePath *)root;
//    {
//        GtkTreeStore_set_root (cptr_g, root_g);
//    }
//}
//
//GtkTreePath * GtkTreeStore_get_last (GtkTreeStore * cptr) 
//{
//    return cptr->last;
//}
//
///*
// * Class:     org.gnu.gtk.TreeStore
// * Method:    getLast
// * Signature: (I)I
// */
//JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeStore_getLast (JNIEnv *env, jclass cls, jint cptr) 
//{
//    GtkTreeStore *cptr_g = (GtkTreeStore *)cptr;
//    {
//        return (jint)GtkTreeStore_get_last (cptr_g);
//    }
//}
//
//void GtkTreeStore_set_last (GtkTreeStore * cptr, GtkTreePath * last) 
//{
//    cptr->last = last;
//}
//
///*
// * Class:     org.gnu.gtk.TreeStore
// * Method:    setLast
// * Signature: (II)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeStore_setLast (JNIEnv *env, jint cptr, jint last) 
//{
//    GtkTreeStore *cptr_g = (GtkTreeStore *)cptr;
//    GtkTreePath *last_g = (GtkTreePath *)last;
//    {
//        GtkTreeStore_set_last (cptr_g, last_g);
//    }
//}
//
//gint32 GtkTreeStore_get_n_columns (GtkTreeStore * cptr) 
//{
//    return cptr->n_columns;
//}
//
///*
// * Class:     org.gnu.gtk.TreeStore
// * Method:    getNColumns
// * Signature: (I)I
// */
//JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeStore_getNColumns (JNIEnv *env, jclass cls, jint 
//    cptr) 
//{
//    GtkTreeStore *cptr_g = (GtkTreeStore *)cptr;
//    {
//        jint result_j = (jint) (GtkTreeStore_get_n_columns (cptr_g));
//        return result_j;
//    }
//}
//
//void GtkTreeStore_set_n_columns (GtkTreeStore * cptr, gint32 n_columns) 
//{
//    cptr->n_columns = n_columns;
//}
//
///*
// * Class:     org.gnu.gtk.TreeStore
// * Method:    setNColumns
// * Signature: (II)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeStore_setNColumns (JNIEnv *env, jint cptr, jint 
//    n_columns) 
//{
//    GtkTreeStore *cptr_g = (GtkTreeStore *)cptr;
//    gint32 n_columns_g = (gint32) n_columns;
//    {
//        GtkTreeStore_set_n_columns (cptr_g, n_columns_g);
//    }
//}

gint32 GtkTreeStore_get_sort_column_id (GtkTreeStore * cptr) 
{
    return cptr->sort_column_id;
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    getSortColumnId
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeStore_getSortColumnId (JNIEnv *env, jclass cls, 
    jint cptr) 
{
    GtkTreeStore *cptr_g = (GtkTreeStore *)cptr;
    {
        jint result_j = (jint) (GtkTreeStore_get_sort_column_id (cptr_g));
        return result_j;
    }
}

void GtkTreeStore_set_sort_column_id (GtkTreeStore * cptr, gint32 sort_column_id) 
{
    cptr->sort_column_id = sort_column_id;
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    setSortColumnId
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeStore_setSortColumnId (JNIEnv *env, jint cptr, jint 
    sort_column_id) 
{
    GtkTreeStore *cptr_g = (GtkTreeStore *)cptr;
    gint32 sort_column_id_g = (gint32) sort_column_id;
    {
        GtkTreeStore_set_sort_column_id (cptr_g, sort_column_id_g);
    }
}

GtkSortType GtkTreeStore_get_order (GtkTreeStore * cptr) 
{
    return cptr->order;
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    getOrder
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeStore_getOrder (JNIEnv *env, jclass cls, jint cptr) 
{
    GtkTreeStore *cptr_g = (GtkTreeStore *)cptr;
    {
        jint result_j = (jint) (GtkTreeStore_get_order (cptr_g));
        return result_j;
    }
}

void GtkTreeStore_set_order (GtkTreeStore * cptr, GtkSortType order) 
{
    cptr->order = order;
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    setOrder
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeStore_setOrder (JNIEnv *env, jint cptr, jint order) 
{
    GtkTreeStore *cptr_g = (GtkTreeStore *)cptr;
    GtkSortType order_g = (GtkSortType) order;
    {
        GtkTreeStore_set_order (cptr_g, order_g);
    }
}

//GType * GtkTreeStore_get_column_headers (GtkTreeStore * cptr) 
//{
//    return cptr->column_headers;
//}
//
///*
// * Class:     org.gnu.gtk.TreeStore
// * Method:    getColumnHeaders
// * Signature: (I)I
// */
//JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeStore_getColumnHeaders (JNIEnv *env, jclass cls, 
//    jint cptr) 
//{
//    GtkTreeStore *cptr_g = (GtkTreeStore *)cptr;
//    {
//        return (jint)GtkTreeStore_get_column_headers (cptr_g);
//    }
//}
//
//void GtkTreeStore_set_column_headers (GtkTreeStore * cptr, GType * column_headers) 
//{
//    cptr->column_headers = column_headers;
//}
//
///*
// * Class:     org.gnu.gtk.TreeStore
// * Method:    setColumnHeaders
// * Signature: (II)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeStore_setColumnHeaders (JNIEnv *env, jint cptr, 
//    jint column_headers) 
//{
//    GtkTreeStore *cptr_g = (GtkTreeStore *)cptr;
//    GType *column_headers_g = (GType *)column_headers;
//    {
//        GtkTreeStore_set_column_headers (cptr_g, column_headers_g);
//    }
//}
//
//gboolean GtkTreeStore_get_columns_dirty (GtkTreeStore * cptr) 
//{
//    return cptr->columns_dirty;
//}
//
///*
// * Class:     org.gnu.gtk.TreeStore
// * Method:    getColumnsDirty
// * Signature: (I)Z
// */
//JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeStore_getColumnsDirty (JNIEnv *env, jclass cls, 
//    jint cptr) 
//{
//    GtkTreeStore *cptr_g = (GtkTreeStore *)cptr;
//    {
//        jboolean result_j = (jboolean) (GtkTreeStore_get_columns_dirty (cptr_g));
//        return result_j;
//    }
//}
//
//void GtkTreeStore_set_columns_dirty (GtkTreeStore * cptr, gboolean columns_dirty) 
//{
//    cptr->columns_dirty = columns_dirty;
//}
//
///*
// * Class:     org.gnu.gtk.TreeStore
// * Method:    setColumnsDirty
// * Signature: (IZ)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeStore_setColumnsDirty (JNIEnv *env, jint cptr, 
//    jboolean columns_dirty) 
//{
//    GtkTreeStore *cptr_g = (GtkTreeStore *)cptr;
//    gboolean columns_dirty_g = (gboolean) columns_dirty;
//    {
//        GtkTreeStore_set_columns_dirty (cptr_g, columns_dirty_g);
//    }
//}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    gtk_tree_store_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1get_1type (JNIEnv *env, 
    jclass cls) 
{
	return (jint)gtk_tree_store_get_type ();
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    gtk_tree_store_newv
 * Signature: (I[Lint ;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1newv (JNIEnv *env, jclass 
    cls, jint numColumns, jintArray types) 
{
    gint32 numColumns_g = (gint32) numColumns;
    gint *types_g_g = (gint *) (*env)->GetIntArrayElements (env, types, NULL);
    GType *types_g = (GType *)types_g_g;
    {
        return (jint)gtk_tree_store_newv (numColumns_g, types_g);
    }
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    gtk_tree_store_set_column_types
 * Signature: (II[Lint ;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1set_1column_1types (JNIEnv 
    *env, jclass cls, jint treeStore, jint numColumns, jintArray types) 
{
    GtkTreeStore *treeStore_g = (GtkTreeStore *)treeStore;
    gint32 numColumns_g = (gint32) numColumns;
    gint *types_g_g = (gint *) (*env)->GetIntArrayElements (env, types, NULL);
    GType *types_g = (GType *)types_g_g;
    {
        gtk_tree_store_set_column_types (treeStore_g, numColumns_g, types_g);
        (*env)->ReleaseIntArrayElements (env, types, (jint *)types_g_g, 0);
    }
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    gtk_tree_store_set_value
 * Signature: (IIII)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1set_1value (JNIEnv *env, 
    jclass cls, jint treeStore, jint iter, jint columnt, jint value) 
{
    GtkTreeStore *treeStore_g = (GtkTreeStore *)treeStore;
    GtkTreeIter *iter_g = (GtkTreeIter *)iter;
    gint32 columnt_g = (gint32) columnt;
    GValue *value_g = (GValue *)value;
    {
        gtk_tree_store_set_value (treeStore_g, iter_g, columnt_g, value_g);
    }
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    gtk_tree_store_remove
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1remove (JNIEnv *env, jclass 
    cls, jint treeStore, jint iter) 
{
    GtkTreeStore *treeStore_g = (GtkTreeStore *)treeStore;
    GtkTreeIter *iter_g = (GtkTreeIter *)iter;
    {
        gtk_tree_store_remove (treeStore_g, iter_g);
    }
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    gtk_tree_store_insert
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1insert (JNIEnv *env, jclass 
    cls, jint treeStore, jint parent, jint position) 
{
    GtkTreeStore *treeStore_g = (GtkTreeStore *)treeStore;
    GtkTreeIter *iter_g = (GtkTreeIter *)g_malloc(sizeof(GtkTreeIter));
    GtkTreeIter *parent_g = (GtkTreeIter *)parent;
    gint32 position_g = (gint32) position;
    gtk_tree_store_insert (treeStore_g, iter_g, parent_g, position_g);
    return (jint)iter_g;
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    gtk_tree_store_insert_before
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1insert_1before (JNIEnv 
    *env, jclass cls, jint treeStore, jint parent, jint sibling) 
{
    GtkTreeStore *treeStore_g = (GtkTreeStore *)treeStore;
    GtkTreeIter *iter_g = (GtkTreeIter *)g_malloc(sizeof(GtkTreeIter));;
    GtkTreeIter *parent_g = (GtkTreeIter *)parent;
    GtkTreeIter *sibling_g = (GtkTreeIter *)sibling;
    gtk_tree_store_insert_before (treeStore_g, iter_g, parent_g, sibling_g);
    return (jint)iter_g;
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    gtk_tree_store_insert_after
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1insert_1after (JNIEnv *env, 
    jclass cls, jint treeStore, jint parent, jint sibling) 
{
    GtkTreeStore *treeStore_g = (GtkTreeStore *)treeStore;
    GtkTreeIter *iter_g = (GtkTreeIter *)g_malloc(sizeof(GtkTreeIter));;
    GtkTreeIter *parent_g = (GtkTreeIter *)parent;
    GtkTreeIter *sibling_g = (GtkTreeIter *)sibling;
	gtk_tree_store_insert_after (treeStore_g, iter_g, parent_g, sibling_g);
    return (jint)iter_g;
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    gtk_tree_store_prepend
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1prepend (JNIEnv *env, 
    jclass cls, jint treeStore, jint parent) 
{
    GtkTreeStore *treeStore_g = (GtkTreeStore *)treeStore;
    GtkTreeIter *iter_g = (GtkTreeIter *)g_malloc(sizeof(GtkTreeIter));;
    GtkTreeIter *parent_g = (GtkTreeIter *)parent;
	gtk_tree_store_prepend (treeStore_g, iter_g, parent_g);
    return (jint)iter_g;
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    gtk_tree_store_append
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1append (JNIEnv *env, jclass 
    cls, jint treeStore, jint parent) 
{
    GtkTreeStore *treeStore_g = (GtkTreeStore *)treeStore;
    GtkTreeIter *iter_g = (GtkTreeIter *)g_malloc(sizeof(GtkTreeIter));;
    GtkTreeIter *parent_g = (GtkTreeIter *)parent;
	gtk_tree_store_append (treeStore_g, iter_g, parent_g);
    return (jint)iter_g;
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    gtk_tree_store_is_ancestor
 * Signature: (III)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1is_1ancestor (JNIEnv 
    *env, jclass cls, jint treeStore, jint iter, jint descendant) 
{
    GtkTreeStore *treeStore_g = (GtkTreeStore *)treeStore;
    GtkTreeIter *iter_g = (GtkTreeIter *)iter;
    GtkTreeIter *descendant_g = (GtkTreeIter *)descendant;
    {
        jboolean result_j = (jboolean) (gtk_tree_store_is_ancestor (treeStore_g, iter_g, 
                descendant_g));
        return result_j;
    }
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    gtk_tree_store_iter_depth
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1iter_1depth (JNIEnv *env, 
    jclass cls, jint treeStore, jint iter) 
{
    GtkTreeStore *treeStore_g = (GtkTreeStore *)treeStore;
    GtkTreeIter *iter_g = (GtkTreeIter *)iter;
    {
        jint result_j = (jint) (gtk_tree_store_iter_depth (treeStore_g, iter_g));
        return result_j;
    }
}

/*
 * Class:     org.gnu.gtk.TreeStore
 * Method:    gtk_tree_store_clear
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1clear (JNIEnv *env, jclass 
    cls, jint treeStore) 
{
    GtkTreeStore *treeStore_g = (GtkTreeStore *)treeStore;
    {
        gtk_tree_store_clear (treeStore_g);
    }
}

/*
 * Class:     org_gnu_gtk_TreeStore
 * Method:    gtk_tree_store_iter_is_valid
 * Signature: (II)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1iter_1is_1valid
  (JNIEnv *env, jclass cls, jint treeStore, jint iter)
{
	return (jboolean)gtk_tree_store_iter_is_valid((GtkTreeStore*)treeStore, (GtkTreeIter*)iter);
}
                                                                                         
/*
 * Class:     org_gnu_gtk_TreeStore
 * Method:    gtk_tree_store_reorder
 * Signature: (II[I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1reorder
  (JNIEnv *env, jclass cls, jint store, jint parent, jintArray order)
{
	gint* newOrder = (gint*)(*env)->GetIntArrayElements(env, order, NULL);
	gtk_tree_store_reorder((GtkTreeStore*)store, (GtkTreeIter*)parent, newOrder);
}
                                                                                         
/*
 * Class:     org_gnu_gtk_TreeStore
 * Method:    gtk_tree_store_swap
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1swap
  (JNIEnv *env, jclass cls, jint store, jint a, jint b)
{
	gtk_tree_store_swap((GtkTreeStore*)store, (GtkTreeIter*)a, (GtkTreeIter*)b);
}
                                                                                         
/*
 * Class:     org_gnu_gtk_TreeStore
 * Method:    gtk_tree_store_move_before
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1move_1before
  (JNIEnv *env, jclass cls, jint store, jint iter, jint pos)
{
	gtk_tree_store_move_before((GtkTreeStore*)store, (GtkTreeIter*)iter, (GtkTreeIter*)pos);
}
                                                                                         
/*
 * Class:     org_gnu_gtk_TreeStore
 * Method:    gtk_tree_store_move_after
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeStore_gtk_1tree_1store_1move_1after
  (JNIEnv *env, jclass cls, jint store, jint iter, jint pos)
{
	gtk_tree_store_move_after((GtkTreeStore*)store, (GtkTreeIter*)iter, (GtkTreeIter*)pos);
}


#ifdef __cplusplus
}

#endif
