/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 13:44:33 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1type (JNIEnv *env, jclass 
        cls) 
    {
        {
            return (jint)pango_layout_get_type ();
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_new
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_Layout_pango_1layout_1new (JNIEnv *env, jclass cls, 
        jint context) 
    {
        PangoContext *context_g = (PangoContext *)context;
        {
            return (jint)pango_layout_new (context_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_copy
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_Layout_pango_1layout_1copy (JNIEnv *env, jclass cls, 
        jint src) 
    {
        PangoLayout *src_g = (PangoLayout *)src;
        {
            return (jint)pango_layout_copy (src_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_context
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1context (JNIEnv *env, 
        jclass cls, jint layout) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        {
            return (jint)pango_layout_get_context (layout_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_set_attributes
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1set_1attributes (JNIEnv *env, 
        jclass cls, jint layout, jint attrs) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        PangoAttrList *attrs_g = (PangoAttrList *)attrs;
        {
            pango_layout_set_attributes (layout_g, attrs_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_attributes
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1attributes (JNIEnv *env, 
        jclass cls, jint layout) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        {
            return (jint)pango_layout_get_attributes (layout_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_set_text
     * Signature: (Ijava.lang.StringI)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1set_1text (JNIEnv *env, jclass 
        cls, jint layout, jstring text, jint length) 
    {
        const gchar* text_g = (*env)->GetStringUTFChars(env, text, 0);
        pango_layout_set_text ((PangoLayout *)layout, text_g, (gint32)length);
        (*env)->ReleaseStringUTFChars(env, text, text_g);
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_text
     * Signature: (I)java.lang.String
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1text (JNIEnv *env, 
        jclass cls, jint layout) 
    {
        const gchar *result_g = pango_layout_get_text ((PangoLayout *)layout);
        return (*env)->NewStringUTF(env, result_g);
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_set_markup
     * Signature: (Ijava.lang.String;I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1set_1markup (JNIEnv *env, 
        jclass cls, jint layout, jstring markup, jint length) 
    {
        const gchar* markup_g = (*env)->GetStringUTFChars(env, markup, 0);
        pango_layout_set_markup ((PangoLayout *)layout, markup_g, (gint32)length);
        (*env)->ReleaseStringUTFChars(env, markup, markup_g);
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_set_markup_with_accel
     * Signature: (Ijava.lang.String;IBB)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1set_1markup_1with_1accel (
        JNIEnv *env, jclass cls, jint layout, jstring markup, jint length, jbyte accelMarker, 
        jbyte accelChar) 
    {
        const gchar* markup_g = (*env)->GetStringUTFChars(env, markup, 0);
        pango_layout_set_markup_with_accel ((PangoLayout *)layout, markup_g, (gint32)length, (gunichar)accelMarker, 
            (gunichar*)&accelChar);
       	(*env)->ReleaseStringUTFChars(env, markup, markup_g);
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_set_font_description
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1set_1font_1description (JNIEnv 
        *env, jclass cls, jint layout, jint desc) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        PangoFontDescription *desc_g = (PangoFontDescription *)desc;
        {
            pango_layout_set_font_description (layout_g, desc_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_set_width
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1set_1width (JNIEnv *env, jclass 
        cls, jint layout, jint width) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        gint32 width_g = (gint32) width;
        {
            pango_layout_set_width (layout_g, width_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_width
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1width (JNIEnv *env, jclass 
        cls, jint layout) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        {
            jint result_j = (jint) (pango_layout_get_width (layout_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_set_wrap
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1set_1wrap (JNIEnv *env, jclass 
        cls, jint layout, jint wrap) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        PangoWrapMode wrap_g = (PangoWrapMode) wrap;
        {
            pango_layout_set_wrap (layout_g, wrap_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_wrap
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1wrap (JNIEnv *env, jclass 
        cls, jint layout) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        {
            jint result_j = (jint) (pango_layout_get_wrap (layout_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_set_indent
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1set_1indent (JNIEnv *env, 
        jclass cls, jint layout, jint indent) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        gint32 indent_g = (gint32) indent;
        {
            pango_layout_set_indent (layout_g, indent_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_indent
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1indent (JNIEnv *env, 
        jclass cls, jint layout) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        {
            jint result_j = (jint) (pango_layout_get_indent (layout_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_set_spacing
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1set_1spacing (JNIEnv *env, 
        jclass cls, jint layout, jint spacing) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        gint32 spacing_g = (gint32) spacing;
        {
            pango_layout_set_spacing (layout_g, spacing_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_spacing
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1spacing (JNIEnv *env, 
        jclass cls, jint layout) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        {
            jint result_j = (jint) (pango_layout_get_spacing (layout_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_set_justify
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1set_1justify (JNIEnv *env, 
        jclass cls, jint layout, jboolean justify) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        gboolean justify_g = (gboolean) justify;
        {
            pango_layout_set_justify (layout_g, justify_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_justify
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1justify (JNIEnv *env, 
        jclass cls, jint layout) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        {
            jboolean result_j = (jboolean) (pango_layout_get_justify (layout_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_set_alignment
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1set_1alignment (JNIEnv *env, 
        jclass cls, jint layout, jint alignment) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        PangoAlignment alignment_g = (PangoAlignment) alignment;
        {
            pango_layout_set_alignment (layout_g, alignment_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_alignment
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1alignment (JNIEnv *env, 
        jclass cls, jint layout) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        {
            jint result_j = (jint) (pango_layout_get_alignment (layout_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_set_tabs
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1set_1tabs (JNIEnv *env, jclass 
        cls, jint layout, jint tabs) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        PangoTabArray *tabs_g = (PangoTabArray *)tabs;
        {
            pango_layout_set_tabs (layout_g, tabs_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_tabs
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1tabs (JNIEnv *env, jclass 
        cls, jint layout) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        {
            return (jint)pango_layout_get_tabs (layout_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_set_single_paragraph_mode
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1set_1single_1paragraph_1mode (
        JNIEnv *env, jclass cls, jint layout, jboolean setting) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        gboolean setting_g = (gboolean) setting;
        {
            pango_layout_set_single_paragraph_mode (layout_g, setting_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_single_paragraph_mode
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL 
    Java_org_gnu_pango_Layout_pango_1layout_1get_1single_1paragraph_1mode (JNIEnv *env, jclass cls, 
        jint layout) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        {
            jboolean result_j = (jboolean) (pango_layout_get_single_paragraph_mode (layout_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_context_changed
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1context_1changed (JNIEnv *env, 
        jclass cls, jint layout) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        {
            pango_layout_context_changed (layout_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_index_to_pos
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1index_1to_1pos (JNIEnv *env, 
        jclass cls, jint layout, jint index, jint pos) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        gint32 index_g = (gint32) index;
        PangoRectangle *pos_g = (PangoRectangle *)pos;
        {
            pango_layout_index_to_pos (layout_g, index_g, pos_g);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_cursor_pos
     * Signature: (II[Lint ;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1cursor_1pos (JNIEnv *env, 
        jclass cls, jint layout, jint index, jintArray strongPos, jintArray weakPos) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        gint32 index_g = (gint32) index;
        gint *strongPos_g_g = (gint *) (*env)->GetIntArrayElements (env, strongPos, NULL);
        PangoRectangle *strongPos_g = (PangoRectangle *)strongPos_g_g;
        gint *weakPos_g_g = (gint *) (*env)->GetIntArrayElements (env, weakPos, NULL);
        PangoRectangle *weakPos_g = (PangoRectangle *)weakPos_g_g;
        {
            pango_layout_get_cursor_pos (layout_g, index_g, strongPos_g, weakPos_g);
            (*env)->ReleaseIntArrayElements (env, strongPos, (jint *)strongPos_g_g, 0);
            (*env)->ReleaseIntArrayElements (env, weakPos, (jint *)weakPos_g_g, 0);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_move_cursor_visually
     * Signature: (IZIII[Lint ;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1move_1cursor_1visually (JNIEnv 
        *env, jclass cls, jint layout, jboolean strong, jint oldIndex, jint oldTrailing, jint 
        direction, jintArray newIndex, jintArray newTrailing) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        gboolean strong_g = (gboolean) strong;
        gint32 oldIndex_g = (gint32) oldIndex;
        gint32 oldTrailing_g = (gint32) oldTrailing;
        gint32 direction_g = (gint32) direction;
        gint *newIndex_g = (gint *) (*env)->GetIntArrayElements (env, newIndex, NULL);
        gint *newTrailing_g = (gint *) (*env)->GetIntArrayElements (env, newTrailing, NULL);
        {
            pango_layout_move_cursor_visually (layout_g, strong_g, oldIndex_g, oldTrailing_g, 
                direction_g, newIndex_g, newTrailing_g);
            (*env)->ReleaseIntArrayElements (env, newIndex, (jint *) newIndex_g, 0);
            (*env)->ReleaseIntArrayElements (env, newTrailing, (jint *) newTrailing_g, 0);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_xy_to_index
     * Signature: (III[Lint ;[Lint ;)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_pango_Layout_pango_1layout_1xy_1to_1index (JNIEnv *env, 
        jclass cls, jint layout, jint x, jint y, jintArray index, jintArray trailing) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        gint32 x_g = (gint32) x;
        gint32 y_g = (gint32) y;
        gint *index_g = (gint *) (*env)->GetIntArrayElements (env, index, NULL);
        gint *trailing_g = (gint *) (*env)->GetIntArrayElements (env, trailing, NULL);
        {
            jboolean result_j = (jboolean) (pango_layout_xy_to_index (layout_g, x_g, y_g, index_g, 
                    trailing_g));
            (*env)->ReleaseIntArrayElements (env, index, (jint *) index_g, 0);
            (*env)->ReleaseIntArrayElements (env, trailing, (jint *) trailing_g, 0);
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_extents
     * Signature: (I[Lint ;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1extents (JNIEnv *env, 
        jclass cls, jint layout, jintArray inkRect, jintArray logicalRect) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        gint *inkRect_g_g = (gint *) (*env)->GetIntArrayElements (env, inkRect, NULL);
        PangoRectangle *inkRect_g = (PangoRectangle *)inkRect_g_g;
        gint *logicalRect_g_g = (gint *) (*env)->GetIntArrayElements (env, logicalRect, NULL);
        PangoRectangle *logicalRect_g = (PangoRectangle *)logicalRect_g_g;
        {
            pango_layout_get_extents (layout_g, inkRect_g, logicalRect_g);
            (*env)->ReleaseIntArrayElements (env, inkRect, (jint *)inkRect_g_g, 0);
            (*env)->ReleaseIntArrayElements (env, logicalRect, (jint *)logicalRect_g_g, 0);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_pixel_extents
     * Signature: (I[Lint ;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1pixel_1extents (JNIEnv 
        *env, jclass cls, jint layout, jintArray inkRect, jintArray logicalRect) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        gint *inkRect_g_g = (gint *) (*env)->GetIntArrayElements (env, inkRect, NULL);
        PangoRectangle *inkRect_g = (PangoRectangle *)inkRect_g_g;
        gint *logicalRect_g_g = (gint *) (*env)->GetIntArrayElements (env, logicalRect, NULL);
        PangoRectangle *logicalRect_g = (PangoRectangle *)logicalRect_g_g;
        {
            pango_layout_get_pixel_extents (layout_g, inkRect_g, logicalRect_g);
            (*env)->ReleaseIntArrayElements (env, inkRect, (jint *)inkRect_g_g, 0);
            (*env)->ReleaseIntArrayElements (env, logicalRect, (jint *)logicalRect_g_g, 0);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_size
     * Signature: (I[Lint ;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1size (JNIEnv *env, jclass 
        cls, jint layout, jintArray width, jintArray height) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        gint *width_g = (gint *) (*env)->GetIntArrayElements (env, width, NULL);
        gint *height_g = (gint *) (*env)->GetIntArrayElements (env, height, NULL);
        {
            pango_layout_get_size (layout_g, width_g, height_g);
            (*env)->ReleaseIntArrayElements (env, width, (jint *) width_g, 0);
            (*env)->ReleaseIntArrayElements (env, height, (jint *) height_g, 0);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_pixel_size
     * Signature: (I[Lint ;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1pixel_1size (JNIEnv *env, 
        jclass cls, jint layout, jintArray width, jintArray height) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        gint *width_g = (gint *) (*env)->GetIntArrayElements (env, width, NULL);
        gint *height_g = (gint *) (*env)->GetIntArrayElements (env, height, NULL);
        {
            pango_layout_get_pixel_size (layout_g, width_g, height_g);
            (*env)->ReleaseIntArrayElements (env, width, (jint *) width_g, 0);
            (*env)->ReleaseIntArrayElements (env, height, (jint *) height_g, 0);
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_line_count
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1line_1count (JNIEnv *env, 
        jclass cls, jint layout) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        {
            jint result_j = (jint) (pango_layout_get_line_count (layout_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.pango.Layout
     * Method:    pango_layout_get_line
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_Layout_pango_1layout_1get_1line (JNIEnv *env, jclass 
        cls, jint layout, jint line) 
    {
        PangoLayout *layout_g = (PangoLayout *)layout;
        gint32 line_g = (gint32) line;
        {
            return (jint)pango_layout_get_line (layout_g, line_g);
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
