/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_ToolButton
#define _Included_org_gnu_gtk_ToolButton
#ifdef __cplusplus
extern "C" {
#endif
/* Inaccessible static: evtMap */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024LifeCycleListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024FocusListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024KeyListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024MouseListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024DragDestinationListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024DragSourceListener */
/* Inaccessible static: evtMap */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024ContainerListener */
/*
 * Class:     org_gnu_gtk_ToolButton
 * Method:    gtk_tool_button_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToolButton_gtk_1tool_1button_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_tool_button_get_type();
}

/*
 * Class:     org_gnu_gtk_ToolButton
 * Method:    gtk_tool_button_new
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToolButton_gtk_1tool_1button_1new
  (JNIEnv *env, jclass cls, jint iconWidget, jstring label)
{
	const gchar* l = (*env)->GetStringUTFChars(env, label, NULL);
	jint handle = (jint)gtk_tool_button_new((GtkWidget*)iconWidget, l);
	(*env)->ReleaseStringUTFChars(env, label, l);
	return handle;
}

/*
 * Class:     org_gnu_gtk_ToolButton
 * Method:    gtk_tool_button_new_from_stock
 * Signature: (Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToolButton_gtk_1tool_1button_1new_1from_1stock
  (JNIEnv *env, jclass cls, jstring stock)
{
	const gchar* s = (*env)->GetStringUTFChars(env, stock, NULL);
	jint handle = (jint)gtk_tool_button_new_from_stock(s);
	(*env)->ReleaseStringUTFChars(env, stock, s);
	return handle;
}

/*
 * Class:     org_gnu_gtk_ToolButton
 * Method:    gtk_tool_button_set_label
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToolButton_gtk_1tool_1button_1set_1label
  (JNIEnv *env, jclass cls, jint button, jstring label)
{
	const gchar* l = (*env)->GetStringUTFChars(env, label, NULL);
	gtk_tool_button_set_label((GtkToolButton*)button, l);
	(*env)->ReleaseStringUTFChars(env, label, l);
}

/*
 * Class:     org_gnu_gtk_ToolButton
 * Method:    gtk_tool_button_get_label
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_ToolButton_gtk_1tool_1button_1get_1label
  (JNIEnv *env, jclass cls, jint button)
{
	return (*env)->NewStringUTF(env, gtk_tool_button_get_label((GtkToolButton*)button));
}

/*
 * Class:     org_gnu_gtk_ToolButton
 * Method:    gtk_tool_button_set_use_underline
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToolButton_gtk_1tool_1button_1set_1use_1underline
  (JNIEnv *env, jclass cls, jint button, jboolean underline)
{
	gtk_tool_button_set_use_underline((GtkToolButton*)button, (gboolean)underline);
}

/*
 * Class:     org_gnu_gtk_ToolButton
 * Method:    gtk_tool_button_get_use_underline
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_ToolButton_gtk_1tool_1button_1get_1use_1underline
  (JNIEnv *env, jclass cls, jint button)
{
	return (jboolean)gtk_tool_button_get_use_underline((GtkToolButton*)button);
}

/*
 * Class:     org_gnu_gtk_ToolButton
 * Method:    gtk_tool_button_set_stock_id
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToolButton_gtk_1tool_1button_1set_1stock_1id
  (JNIEnv *env, jclass cls, jint button, jstring stock)
{
	const gchar* s = (*env)->GetStringUTFChars(env, stock, NULL);
	gtk_tool_button_set_stock_id((GtkToolButton*)button, s);
	(*env)->ReleaseStringUTFChars(env, stock, s);
}

/*
 * Class:     org_gnu_gtk_ToolButton
 * Method:    gtk_tool_button_get_stock_id
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_ToolButton_gtk_1tool_1button_1get_1stock_1id
  (JNIEnv *env, jclass cls, jint button)
{
	return (*env)->NewStringUTF(env, gtk_tool_button_get_stock_id((GtkToolButton*)button));
}

/*
 * Class:     org_gnu_gtk_ToolButton
 * Method:    gtk_tool_button_set_icon_widget
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToolButton_gtk_1tool_1button_1set_1icon_1widget
  (JNIEnv *env, jclass cls, jint button, jint icon)
{
	gtk_tool_button_set_icon_widget((GtkToolButton*)button, (GtkWidget*)icon);
}

/*
 * Class:     org_gnu_gtk_ToolButton
 * Method:    gtk_tool_button_get_icon_widget
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToolButton_gtk_1tool_1button_1get_1icon_1widget
  (JNIEnv *env, jclass cls, jint button)
{
	return (jint)gtk_tool_button_get_icon_widget((GtkToolButton*)button);
}

/*
 * Class:     org_gnu_gtk_ToolButton
 * Method:    gtk_tool_button_set_label_widget
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToolButton_gtk_1tool_1button_1set_1label_1widget
  (JNIEnv *env, jclass cls, jint button, jint label)
{
	gtk_tool_button_set_label_widget((GtkToolButton*)button, (GtkWidget*)label);
}

/*
 * Class:     org_gnu_gtk_ToolButton
 * Method:    gtk_tool_button_get_label_widget
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToolButton_gtk_1tool_1button_1get_1label_1widget
  (JNIEnv *env, jclass cls, jint button)
{
	return (jint)gtk_tool_button_get_label_widget((GtkToolButton*)button);
}

#ifdef __cplusplus
}
#endif
#endif
