/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.Boxed;
/**
 * The PangoColor structure is used to represent a color in an uncalibrated RGB
 * colorspace.
 */
public class Color extends Boxed 
{

	protected Color(int handle){
		this.handle = handle;
	}

	/**
	 * Returns the red component of the color. This is a value between 0 and
	 * 65535, with 65535 indicating full intensity.
	 */
	public int getRed(){
		return getRed(handle);
	}

	/**
	 * Returns the Green component of the color. This is a value between 0 and
	 * 65535, with 65535 indicating full intensity.
	 */
	public int getGreen(){
		return getGreen(handle);
	}

	/**
	 * Returns the Blue component of the color. This is a value between 0 and
	 * 65535, with 65535 indicating full intensity.
	 */
	public int getBlue(){
		return getBlue(handle);
	}


	/**
	 * Fill in the fields of a color from a string specification. The string can
	 * either one of a large set of standard names. (Taken from the X11 rgb.txt
	 * file), or it can be a hex value in the form 'rgb' 'rrggbb' 'rrrgggbbb' or
	 * 'rrrrggggbbbb' where 'r', 'g' and 'b' are hex digits of the red, green,
	 * and blue components of the color, respectively. (White in the four forms
	 * is 'fff' 'ffffff' 'fffffffff' and 'ffffffffffff')
	 * @param spec A string specifying the new color
	 * @return  TRUE if parsing of the specifier succeeded, otherwise false.
	 */
	public boolean setColor(String spec){
		return pango_color_parse(handle, spec);
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getRed (int obj);
    native static final protected int getGreen (int obj);
    native static final protected int getBlue (int obj);
    native static final protected int pango_color_get_type ();
    native static final protected int pango_color_copy (int src);
    native static final protected void pango_color_free (int color);
    native static final protected boolean pango_color_parse (int color, String spec);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

