/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtk;

import java.util.ArrayList;
import java.util.List;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

/**
 */
public class RadioAction extends ToggleAction {
	
	public RadioAction(String name, String label, String tooltip, String stockId, int value) {
		super(gtk_radio_action_new(name, label, tooltip, stockId, value));
	}
	
	RadioAction(Handle handle) {
		super(handle);
	}


	public List getGroup(){
	    Handle[] group = gtk_radio_action_get_group(getHandle());
		List ret = new ArrayList();
		for (int i = 0; i < group.length; i++) {
			GObject obj = getGObjectFromHandle(group[i]);
			RadioAction action;
			if (null != obj)
				action = (RadioAction)obj;
			else
				action = new RadioAction(group[i]);
			ret.add(action);
		}
		return ret;
	}
	
	public void setGroup(List group) {
		if (null == group)
			return;
		Handle [] values = new Handle[group.size()];
		for (int i = 0; i < group.size(); i++) {
			values[i] = ((RadioAction)group.get(i)).getHandle();
		}
		gtk_radio_action_set_group(getHandle(), values);
	}
	
	public int getCurrentValue() {
		return gtk_radio_action_get_current_value(getHandle());
	}
	

	native static final protected int gtk_radio_action_get_type ();
	native static final protected Handle gtk_radio_action_new(String name, String label, String tooltip, String stockId, int value);
	native static final protected Handle[] gtk_radio_action_get_group(Handle action);
	native static final protected void gtk_radio_action_set_group(Handle action, Handle[] group);
	native static final protected int gtk_radio_action_get_current_value(Handle action);

}
