/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.glib.EventType;

/**
 * An event represeting action by a {@link org.gnu.gtk.Item} widget.
 */
public class ItemEvent extends GtkEvent {

	/**
	 * Type of a ItemEvent
	 */
	public static class Type extends EventType {
		private Type(int id, String name) {
			super(id, name);
		}

		public static final Type SELECT = new Type(1, "SELECT");

		public static final Type DESELECT = new Type(2, "DESELECT");

		public static final Type TOGGLE = new Type(3, "TOGGLE");

	}

	/**
	 * Creates a new Button Event. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public ItemEvent(Object source, ItemEvent.Type type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(ItemEvent.Type aType) {
		return (type.getID() == aType.getID());
	}
}
