/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif


GdkEventType GdkEventCrossing_get_type (GdkEventCrossing * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventCrossing
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventCrossing_getType (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventCrossing *obj_g = (GdkEventCrossing *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventCrossing_get_type (obj_g));
}

GdkWindow * GdkEventCrossing_get_window (GdkEventCrossing * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventCrossing
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventCrossing_getWindow (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventCrossing *obj_g = (GdkEventCrossing *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventCrossing_get_window (obj_g));
}

gboolean GdkEventCrossing_get_send_event (GdkEventCrossing * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventCrossing
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventCrossing_getSendEvent (JNIEnv *env, jclass 
    cls, jobject obj) 
{
    GdkEventCrossing *obj_g = (GdkEventCrossing *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventCrossing_get_send_event (obj_g));
}

GdkWindow * GdkEventCrossing_get_subwindow (GdkEventCrossing * cptr) 
{
    return cptr->subwindow;
}

/*
 * Class:     org.gnu.gdk.EventCrossing
 * Method:    getSubwindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventCrossing_getSubwindow (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventCrossing *obj_g = (GdkEventCrossing *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventCrossing_get_subwindow (obj_g));
}

time_t GdkEventCrossing_get_time (GdkEventCrossing * cptr) 
{
    return cptr->time;
}

/*
 * Class:     org.gnu.gdk.EventCrossing
 * Method:    getTime
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventCrossing_getTime (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventCrossing *obj_g = (GdkEventCrossing *)getPointerFromHandle(env, obj);
    return GdkEventCrossing_get_time (obj_g);
}

gdouble GdkEventCrossing_get_x (GdkEventCrossing * cptr) 
{
    return cptr->x;
}

/*
 * Class:     org.gnu.gdk.EventCrossing
 * Method:    getX
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventCrossing_getX (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventCrossing *obj_g = (GdkEventCrossing *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventCrossing_get_x (obj_g));
}

gdouble GdkEventCrossing_get_y (GdkEventCrossing * cptr) 
{
    return cptr->y;
}

/*
 * Class:     org.gnu.gdk.EventCrossing
 * Method:    getY
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventCrossing_getY (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventCrossing *obj_g = (GdkEventCrossing *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventCrossing_get_y (obj_g));
}

gdouble GdkEventCrossing_get_x_root (GdkEventCrossing * cptr) 
{
    return cptr->x_root;
}

/*
 * Class:     org.gnu.gdk.EventCrossing
 * Method:    getXRoot
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventCrossing_getXRoot (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventCrossing *obj_g = (GdkEventCrossing *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventCrossing_get_x_root (obj_g));
}

gdouble GdkEventCrossing_get_y_root (GdkEventCrossing * cptr) 
{
    return cptr->y_root;
}

/*
 * Class:     org.gnu.gdk.EventCrossing
 * Method:    getYRoot
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventCrossing_getYRoot (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventCrossing *obj_g = (GdkEventCrossing *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventCrossing_get_y_root (obj_g));
}

GdkCrossingMode GdkEventCrossing_get_mode (GdkEventCrossing * cptr) 
{
    return cptr->mode;
}

/*
 * Class:     org.gnu.gdk.EventCrossing
 * Method:    getMode
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventCrossing_getMode (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventCrossing *obj_g = (GdkEventCrossing *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventCrossing_get_mode (obj_g));
}

GdkNotifyType GdkEventCrossing_get_detail (GdkEventCrossing * cptr) 
{
    return cptr->detail;
}

/*
 * Class:     org.gnu.gdk.EventCrossing
 * Method:    getDetail
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventCrossing_getDetail (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventCrossing *obj_g = (GdkEventCrossing *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventCrossing_get_detail (obj_g));
}

gboolean GdkEventCrossing_get_focus (GdkEventCrossing * cptr) 
{
    return cptr->focus;
}

/*
 * Class:     org.gnu.gdk.EventCrossing
 * Method:    getFocus
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventCrossing_getFocus (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventCrossing *obj_g = (GdkEventCrossing *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventCrossing_get_focus (obj_g));
}

guint32 GdkEventCrossing_get_state (GdkEventCrossing * cptr) 
{
    return cptr->state;
}

/*
 * Class:     org.gnu.gdk.EventCrossing
 * Method:    getState
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventCrossing_getState (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventCrossing *obj_g = (GdkEventCrossing *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventCrossing_get_state (obj_g));
}


#ifdef __cplusplus
}

#endif
