/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

GdkEventType GdkEventSetting_get_type (GdkEventSetting * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventSetting
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventSetting_getType (JNIEnv *env, jclass cls, jobject obj)
{
    GdkEventSetting *obj_g = (GdkEventSetting *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventSetting_get_type (obj_g));
}

GdkWindow * GdkEventSetting_get_window (GdkEventSetting * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventSetting
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventSetting_getWindow (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventSetting *obj_g = (GdkEventSetting *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventSetting_get_window (obj_g));
}

gint32 GdkEventSetting_get_send_event (GdkEventSetting * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventSetting
 * Method:    getSendEvent
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventSetting_getSendEvent (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventSetting *obj_g = (GdkEventSetting *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventSetting_get_send_event (obj_g));
}

GdkSettingAction GdkEventSetting_get_action (GdkEventSetting * cptr) 
{
    return cptr->action;
}

/*
 * Class:     org.gnu.gdk.EventSetting
 * Method:    getAction
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventSetting_getAction (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventSetting *obj_g = (GdkEventSetting *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventSetting_get_action (obj_g));
}

gchar * GdkEventSetting_get_name (GdkEventSetting * cptr) 
{
    return cptr->name;
}

/*
 * Class:     org.gnu.gdk.EventSetting
 * Method:    getName
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gdk_EventSetting_getName (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventSetting *obj_g = (GdkEventSetting *)getPointerFromHandle(env, obj);
    const gchar *result_g = GdkEventSetting_get_name (obj_g);
    return (*env)->NewStringUTF(env, result_g);
}


#ifdef __cplusplus
}

#endif
