/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.javagnome.Handle;
import org.gnu.glib.GObject;
import org.gnu.glib.Type;

/**
 * The VScrollbar displays a vertical scrollbar with a slider and a
 * pair of arror buttons. To create a scrollbar, you must specify the
 * beginning and ending values, the size of the slider, an initial
 * slider position, and how far the slider should move when the mouse
 * clicks the slot.
 * @see HScrollBar
 */
public class VScrollBar extends ScrollBar 
{
	/**
	 * Creates a new ScrollBar
	 * @param adjustment The GtkAdjustment to use, or NULL to create 
	 * a new adjustment.
	 */
	public VScrollBar( Adjustment adjustment ){
		super(gtk_vscrollbar_new( adjustment.getHandle() ));
	}
	
	/**
	 * Construct a VScrollBar from a handle to a native resource.
	 */
	public VScrollBar(Handle handle) {
	    super(handle);
	}
	
    /**
     * Construct a VScrollBar from a handle to a native resource.
     */
    public static VScrollBar getVScrollBar(Handle handle) {
        if (handle == null)
            return null;
        
        VScrollBar obj = (VScrollBar) GObject.getGObjectFromHandle(handle);
        
        if (obj == null)
            obj = new VScrollBar(handle);
        
        return obj;
    }
    
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_vscrollbar_get_type());
	}

    native static final protected int gtk_vscrollbar_get_type ();
    native static final protected Handle gtk_vscrollbar_new (Handle adjustment);
}

