/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.glib.EventType;
import org.gnu.gtk.Widget;

/**
 * This event is used to identify when a HandleBox receives an event
 * 
 * @see HandleBoxListener
 */
public class HandleBoxEvent extends GtkEvent {

    private Widget widget;

    public static class Type extends EventType {
        private Type(int id, String name) {
            super(id, name);
        }

        public static final Type CHILD_ATTACHED = new Type(1, "CHILD_ATTACHED");

        public static final Type CHILD_DETACHED = new Type(2, "CHILD_DETACHED");
    }

    /**
     * Constructor for HandleBoxEvent.
     * 
     * @param source
     * @param type
     */
    public HandleBoxEvent(Object source, EventType type) {
        super(source, type);
    }

    /**
     * @return True if the type of this event is the same as that stated.
     */
    public boolean isOfType(FontButtonEvent.Type aType) {
        return (type.getID() == aType.getID());
    }

    /**
     * @return Returns the widget.
     */
    public Widget getWidget() {
        return widget;
    }

    /**
     * @param widget
     *            The widget to set.
     */
    public void setWidget(Widget widget) {
        this.widget = widget;
    }

}
