/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Handle;
import org.gnu.glib.Type;

/**
 * The SeparatorMenuItem is a separator used to group items within a menu. It
 * displays a horizontal line with a shadow to make it appear sunken into the
 * interface.
 */
public class SeparatorMenuItem extends MenuItem {

    /**
     * Create a new SeparatorMenuItem
     */
    public SeparatorMenuItem() {
        super(gtk_separator_menu_item_new());
    }

    /**
     * Construct a SeparatorMenuItem using a handle to a native resource.
     */
    public SeparatorMenuItem(Handle handle) {
        super(handle);
    }

    /**
     * Internal static factory method to be used by Java-Gnome only.
     */
    public static SeparatorMenuItem getSeparatorMenuItem(Handle handle) {
        if (handle == null)
            return null;

        SeparatorMenuItem obj = (SeparatorMenuItem) getGObjectFromHandle(handle);
        if (obj == null)
            obj = new SeparatorMenuItem(handle);

        return obj;
    }

    /**
     * Retrieve the runtime type used by the GLib library.
     */
    public static Type getType() {
        return new Type(gtk_separator_menu_item_get_type());
    }

    native static final protected int gtk_separator_menu_item_get_type();

    native static final protected Handle gtk_separator_menu_item_new();
}
