/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libical-glib/i-cal-restriction.h>
#include <libical-glib/i-cal-component.h>

/**
 * i_cal_restriction_compare:
 * @restr: The restriction kind
 * @count: The number of restrictions
 *
 * Compare the kind of restriction and the count to determine whether it is valid.
 *
 * Returns: Whether it is valid or not. -1 indicates invalid or more analysis. 1 indicates pass and 0 or 2+ indicates fail.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_restriction_compare (ICalRestrictionKind restr, 
                           gint count)
{
	return icalrestriction_compare (restr, count);
}

/**
 * i_cal_restriction_check:
 * @comp: The component to be checked.
 *
 * Check whether the #ICalComponent is valid.
 *
 * Returns: Whether the @comp is valid.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_restriction_check (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), 0);
	g_return_val_if_fail (comp != NULL, 0);

	return icalrestriction_check ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}