/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined (__LIBICAL_GLIB_H_INSIDE__) && !defined (LIBICAL_GLIB_COMPILATION)
#error "Only <libical-glib/libical-glib.h> can be included directly."
#endif

#ifndef I_CAL_COMP_ITER_H
#define I_CAL_COMP_ITER_H

#include <libical-glib/i-cal-object.h>

G_BEGIN_DECLS

#define I_CAL_COMP_ITER_TYPE \
        (i_cal_comp_iter_get_type ())
#define I_CAL_COMP_ITER(obj) \
        (G_TYPE_CHECK_INSTANCE_CAST \
        ((obj), I_CAL_COMP_ITER_TYPE, ICalCompIter))
#define I_CAL_COMP_ITER_CLASS(klass) \
        (G_TYPE_CHECK_CLASS_CAST \
        ((klass), I_CAL_COMP_ITER_TYPE, ICalCompIterClass))
#define I_CAL_IS_COMP_ITER(obj) \
        (G_TYPE_CHECK_INSTANCE_TYPE \
        ((obj), I_CAL_COMP_ITER_TYPE))
#define I_CAL_IS_COMP_ITER_CLASS(klass) \
        (G_TYPE_CHECK_CLASS_TYPE \
        ((klass), I_CAL_COMP_ITER_TYPE))

/**
 * ICalCompIter:
 *
 * This is the ICalCompIter instance.
 */
typedef struct _ICalCompIter ICalCompIter;

/**
 * ICalCompIterClass:
 *
 * This is the ICalCompIter class.
 */
typedef struct _ICalCompIterClass ICalCompIterClass;

struct _ICalCompIter {
	/*< private >*/
	ICalObject parent;
};

struct _ICalCompIterClass {
	/*< private >*/
	ICalObjectClass parent;
};

ICalCompIter *	i_cal_comp_iter_new_full	(struct icalcompiter native);
GType 		i_cal_comp_iter_get_type	(void);
struct icalcompiter 
		i_cal_comp_iter_new_default	(void);

G_END_DECLS

#endif /* I_CAL_COMP_ITER_H */