/* Generated file (by src-generator) */

/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libical-glib/i-cal-property.h>
#include <libical-glib/i-cal-value.h>
#include <libical-glib/i-cal-parameter.h>
#include <libical-glib/i-cal-derived-value.h>
#include <libical-glib/i-cal-derived-property.h>
#include <libical-glib/i-cal-derived-parameter.h>

G_DEFINE_TYPE (ICalProperty, i_cal_property, I_CAL_TYPE_OBJECT)

static void
i_cal_property_class_init (ICalPropertyClass *klass)
{	
	g_type_class_add_private (klass, sizeof (ICalProperty));
}

static void
i_cal_property_init (ICalProperty *self)
{
}

/**
 * i_cal_property_new_full: (skip)
 * @native: The native libical object.
 * @owner: The parent.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 * 
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalProperty *
i_cal_property_new_full (icalproperty *native, 
                         GObject *owner)
{
	ICalProperty *object;
	if (native == NULL)
		return NULL;
	object = g_object_new (I_CAL_PROPERTY_TYPE, NULL);
	i_cal_object_construct ((ICalObject *)object,
		        	(gpointer) native,
		        	(GDestroyNotify) icalproperty_free,
		        	FALSE,
		        	owner);
    							
	return object;
}

/**
 * i_cal_property_new:
 * @kind: The kind of #ICalProperty to be created.
 *
 * Create a #ICalProperty of the target type.
 *
 * Returns: (transfer full): The newly created #ICalProperty with the type @kind.
 *
 * Since: 1.0
 *
 **/
ICalProperty *
i_cal_property_new (ICalPropertyKind kind)
{
	return i_cal_property_new_full (icalproperty_new (kind), NULL);
}

/**
 * i_cal_property_new_clone:
 * @prop: The #ICalProperty to be cloned.
 *
 * Deeply clone a #ICalProperty.
 *
 * Returns: (transfer full): The newly created #ICalProperty deeply cloned from @prop.
 *
 * Since: 1.0
 *
 **/
ICalProperty *
i_cal_property_new_clone (ICalProperty *prop)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (prop != NULL, NULL);

	return i_cal_property_new_full (icalproperty_new_clone ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop))), NULL);
}

/**
 * i_cal_property_new_from_string:
 * @str: The string used to construct a #ICalProperty.
 *
 * Create a #ICalProperty from a string.
 *
 * Returns: (transfer full): The newly created #ICalProperty from @str.
 *
 * Since: 1.0
 *
 **/
ICalProperty *
i_cal_property_new_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, NULL);

	return i_cal_property_new_full (icalproperty_new_from_string (str), NULL);
}

/**
 * i_cal_property_as_ical_string_r:
 * @prop: The #ICalProperty to be converted.
 *
 * Convert a #ICalProperty to a string representation.
 *
 * Returns: (transfer full): The string representation of @prop.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_property_as_ical_string_r (ICalProperty *prop)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (prop != NULL, NULL);

	return icalproperty_as_ical_string_r ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)));
}

/**
 * i_cal_property_free: (skip)
 * @prop: (transfer full): The #ICalProperty to be freed.
 *
 * Free a #ICalProperty.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_free (ICalProperty *prop)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (prop != NULL);

	icalproperty_free ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)));
}

/**
 * i_cal_property_isa:
 * @property: The #ICalProperty which type is to be determined.
 *
 * Get the kind of #ICalProperty.
 *
 * Returns: The type of #ICalProperty.
 *
 * Since: 1.0
 *
 **/
ICalPropertyKind
i_cal_property_isa (ICalProperty *property)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (property), I_CAL_NO_PROPERTY);
	g_return_val_if_fail (property != NULL, I_CAL_NO_PROPERTY);

	return icalproperty_isa ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (property)));
}

/**
 * i_cal_property_isa_property:
 * @property: The object whose native part to be checked.
 *
 * Check whether the native part of #ICalProperty is of the type icalproperty.
 *
 * Returns: 1 if the native part of @property is of the type icalproperty, 0 if not.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_property_isa_property (ICalProperty *property)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (property), 0);
	g_return_val_if_fail (property != NULL, 0);

	return icalproperty_isa_property ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (property)));
}

/**
 * i_cal_property_add_parameter:
 * @prop: The #ICalProperty to be set.
 * @parameter: (transfer full): The parameter to be added into @prop.
 *
 * Add a #ICalParameter into the #ICalProperty. It behaves like set the copy of the #ICalParameter. Upon
 * completion the native part of #ICalParameter will be set to NULL.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_add_parameter (ICalProperty *prop, 
                              ICalParameter *parameter)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (prop != NULL);
	g_return_if_fail (I_CAL_IS_PARAMETER (parameter));
	g_return_if_fail (parameter != NULL);

	i_cal_object_set_owner ((ICalObject *)parameter, (GObject *)prop);
	icalproperty_add_parameter ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), (icalparameter *)i_cal_object_get_native (I_CAL_OBJECT (parameter)));
}

/**
 * i_cal_property_set_parameter:
 * @prop: The #ICalProperty to be set.
 * @parameter: (transfer full): The parameter to be set into @prop.
 *
 * Set a #ICalParameter into the #ICalProperty. It behaves like set the copy of the #ICalParameter. Upon
 * completion the native part of #ICalParameter will be set to NULL.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_set_parameter (ICalProperty *prop, 
                              ICalParameter *parameter)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (prop != NULL);
	g_return_if_fail (I_CAL_IS_PARAMETER (parameter));
	g_return_if_fail (parameter != NULL);

	i_cal_object_set_owner ((ICalObject *)parameter, (GObject *)prop);
	icalproperty_set_parameter ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), (icalparameter *)i_cal_object_get_native (I_CAL_OBJECT (parameter)));
}

/**
 * i_cal_property_set_parameter_from_string:
 * @prop: The #ICalProperty to be set.
 * @name: The name of the parameter.
 * @value: The value of the parameter.
 *
 * Set the #ICalProperty with the parameter defined by the name and value.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_set_parameter_from_string (ICalProperty *prop, 
                                          const gchar *name, 
                                          const gchar *value)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (prop != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);

	icalproperty_set_parameter_from_string ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), name, value);
}

/**
 * i_cal_property_get_parameter_as_string_r:
 * @prop: The #ICalProperty to be queried.
 * @name: The name of the target parameter.
 *
 * Get the string representation of the target parameter in the #ICalProperty.
 *
 * Returns: (transfer full): The string representation of the parameter.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_property_get_parameter_as_string_r (ICalProperty *prop, 
                                          const gchar *name)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);

	return icalproperty_get_parameter_as_string_r ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), name);
}

/**
 * i_cal_property_remove_parameter:
 * @prop: The #ICalProperty to be manipulated.
 * @kind: The kind of parameter to be removed.
 *
 * Remove the target kind of parameters in #ICalProperty.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_remove_parameter (ICalProperty *prop, 
                                 ICalParameterKind kind)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (prop != NULL);

	icalproperty_remove_parameter ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), kind);
}

/**
 * i_cal_property_remove_parameter_by_kind:
 * @prop: The #ICalProperty to be manipulated.
 * @kind: The #ICalParameterKind to be removed.
 *
 * Remove the target kind of the parameters in the #ICalProperty.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_remove_parameter_by_kind (ICalProperty *prop, 
                                         ICalParameterKind kind)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (prop != NULL);

	icalproperty_remove_parameter_by_kind ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), kind);
}

/**
 * i_cal_property_remove_parameter_by_name:
 * @prop: The #ICalProperty to be manipulated.
 * @name: The name of the parameter to be removed.
 *
 * Remove parameter in the #ICalProperty by name.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_remove_parameter_by_name (ICalProperty *prop, 
                                         const gchar *name)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (prop != NULL);
	g_return_if_fail (name != NULL);

	icalproperty_remove_parameter_by_name ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), name);
}

/**
 * i_cal_property_remove_parameter_by_ref:
 * @prop: The #ICalProperty to be manipulated.
 * @param: The #ICalParameter to be removed.
 *
 * Remove the parameter in the #ICalProperty by ref.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_remove_parameter_by_ref (ICalProperty *prop, 
                                        ICalParameter *param)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (prop != NULL);
	g_return_if_fail (I_CAL_IS_PARAMETER (param));
	g_return_if_fail (param != NULL);

	icalproperty_remove_parameter_by_ref ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), (icalparameter *)i_cal_object_get_native (I_CAL_OBJECT (param)));
}

/**
 * i_cal_property_count_parameters:
 * @prop: The #ICalProperty to be checked.
 *
 * Count the parameters in the #ICalProperty.
 *
 * Returns: The count of the parameters in the #ICalProperty.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_property_count_parameters (const ICalProperty *prop)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), 0);
	g_return_val_if_fail (prop != NULL, 0);

	return icalproperty_count_parameters ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)));
}

/**
 * i_cal_property_get_first_parameter:
 * @prop: The #ICalProperty to be queried.
 * @kind: The target kind of #ICalParameter to be retrieved.
 *
 * Get the first #ICalParameter from the parent #ICalProperty.
 *
 * Returns: (transfer full): The first #ICalParameter of @prop.
 *
 * Since: 1.0
 *
 **/
ICalParameter *
i_cal_property_get_first_parameter (ICalProperty *prop, 
                                    ICalParameterKind kind)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (prop != NULL, NULL);

	return i_cal_parameter_new_full (icalproperty_get_first_parameter ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), kind), (GObject *)prop);
}

/**
 * i_cal_property_get_next_parameter:
 * @prop: The #ICalProperty to be queried.
 * @kind: The target kind of #ICalParameter to be retrieved.
 *
 * Get the next #ICalParameter from the parent #ICalProperty.
 *
 * Returns: (transfer full): The next #ICalParameter of @prop.
 *
 * Since: 1.0
 *
 **/
ICalParameter *
i_cal_property_get_next_parameter (ICalProperty *prop, 
                                   ICalParameterKind kind)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (prop != NULL, NULL);

	return i_cal_parameter_new_full (icalproperty_get_next_parameter ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), kind), (GObject *)prop);
}

/**
 * i_cal_property_set_value:
 * @prop: The target #ICalProperty.
 * @value: The #ICalValue will be set as the property of @prop.
 *
 * Set the #ICalProperty with the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_set_value (ICalProperty *prop, 
                          ICalValue *value)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (prop != NULL);
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (value != NULL);

	i_cal_object_set_owner ((ICalObject *)prop, (GObject *)value);
	i_cal_object_set_owner ((ICalObject *)value, (GObject *)prop);
	icalproperty_set_value ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), (icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)));
}

/**
 * i_cal_property_set_value_from_string:
 * @prop: The #ICalProperty to be set.
 * @value: The value used to construct the #ICalValue.
 * @kind: The kind used to construct the #ICalValue.
 *
 * Set the #ICalProperty with the #ICalValue constructed from string.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_set_value_from_string (ICalProperty *prop, 
                                      const gchar *value, 
                                      const gchar *kind)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (prop != NULL);
	g_return_if_fail (value != NULL);
	g_return_if_fail (kind != NULL);

	icalproperty_set_value_from_string ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), value, kind);
}

/**
 * i_cal_property_get_value:
 * @prop: The #ICalProperty to be queried.
 *
 * Get the #ICalValue of #ICalProperty.
 *
 * Returns: (transfer full): The #ICalValue of @prop.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_property_get_value (const ICalProperty *prop)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (prop != NULL, NULL);

	return i_cal_value_new_full (icalproperty_get_value ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop))), (GObject *)prop);
}

/**
 * i_cal_property_get_value_as_string_r:
 * @prop: The #ICalProperty to be queried.
 *
 * Get the string representation of the value in #ICalProperty.
 *
 * Returns: (transfer full): The string representation of the value of the #ICalProperty.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_property_get_value_as_string_r (const ICalProperty *prop)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (prop != NULL, NULL);

	return icalproperty_get_value_as_string_r ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)));
}

/**
 * i_cal_property_set_x_name:
 * @prop: a #ICalProperty
 * @name: The name string.
 *
 * Set the name of x property for the #ICalProperty.
 *
 * Since: 1.0
 *
 **/
void
i_cal_property_set_x_name (ICalProperty *prop, 
                           const gchar *name)
{
	g_return_if_fail (I_CAL_IS_PROPERTY (prop));
	g_return_if_fail (prop != NULL);
	g_return_if_fail (name != NULL);

	icalproperty_set_x_name ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)), name);
}

/**
 * i_cal_property_get_x_name:
 * @prop: A #ICalProperty.
 *
 * Get the name of x property.
 *
 * Returns: (transfer full): The name of x property.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_property_get_x_name (ICalProperty *prop)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (prop != NULL, NULL);

	return icalproperty_get_x_name ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)));
}

/**
 * i_cal_property_get_property_name_r:
 * @prop: A #ICalProperty.
 *
 * Get the property name of #ICalProperty.
 *
 * Returns: (transfer full): Property name of #ICalProperty.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_property_get_property_name_r (const ICalProperty *prop)
{
	g_return_val_if_fail (I_CAL_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (prop != NULL, NULL);

	return icalproperty_get_property_name_r ((icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (prop)));
}

/**
 * i_cal_parameter_value_to_value_kind:
 * @value: A #ICalParameterValue.
 *
 * Convert the #ICalParameterValue to #ICalValueKind.
 *
 * Returns: #ICalValueKind
 *
 * Since: 1.0
 *
 **/
ICalValueKind
i_cal_parameter_value_to_value_kind (ICalParameterValue value)
{
	return icalparameter_value_to_value_kind (value);
}

/**
 * i_cal_property_kind_to_value_kind:
 * @kind: A #ICalPropertyKind.
 *
 * Convert the #ICalPropertyKind to #ICalValueKind.
 *
 * Returns: The #ICalValueKind
 *
 * Since: 1.0
 *
 **/
ICalValueKind
i_cal_property_kind_to_value_kind (ICalPropertyKind kind)
{
	return icalproperty_kind_to_value_kind (kind);
}

/**
 * i_cal_property_value_kind_to_kind:
 * @kind: A #ICalValueKind
 *
 * Convert a #ICalValueKind to a #ICalPropertyKind.
 *
 * Returns: The #ICalPropertyKind.
 *
 * Since: 1.0
 *
 **/
ICalPropertyKind
i_cal_property_value_kind_to_kind (ICalValueKind kind)
{
	return icalproperty_value_kind_to_kind (kind);
}

/**
 * i_cal_property_kind_to_string:
 * @kind: A #ICalPropertyKind.
 *
 * Convert the #ICalPropertyKind to a string.
 *
 * Returns: The string representation of @kind.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_property_kind_to_string (ICalPropertyKind kind)
{
	return icalproperty_kind_to_string (kind);
}

/**
 * i_cal_property_string_to_kind:
 * @string: A string representing #ICalPropertyKind.
 *
 * Convert the string to #ICalPropertyKind.
 *
 * Returns: The #ICalPropertyKind.
 *
 * Since: 1.0
 *
 **/
ICalPropertyKind
i_cal_property_string_to_kind (const gchar *string)
{
	g_return_val_if_fail (string != NULL, I_CAL_NO_PROPERTY);

	return icalproperty_string_to_kind (string);
}

/**
 * i_cal_property_kind_is_valid:
 * @kind: The #ICalPropertyKind
 *
 * Check whether #ICalPropertyKind is valid.
 *
 * Returns: 1 if valid, 0 if not.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_property_kind_is_valid (const ICalPropertyKind kind)
{
	return icalproperty_kind_is_valid (kind);
}

/**
 * i_cal_property_string_to_method:
 * @str: A string.
 *
 * Convert the string to #ICalPropertyKind.
 *
 * Returns: The #ICalPropertyMethod.
 *
 * Since: 1.0
 *
 **/
ICalPropertyMethod
i_cal_property_string_to_method (const gchar *str)
{
	g_return_val_if_fail (str != NULL, I_CAL_METHOD_NONE);

	return icalproperty_string_to_method (str);
}

/**
 * i_cal_property_method_to_string:
 * @method: The #ICalPropertyMethod.
 *
 * Convert the #ICalPropertyMethod to string.
 *
 * Returns: The string representation of #ICalPropertyMethod.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_property_method_to_string (ICalPropertyMethod method)
{
	return icalproperty_method_to_string (method);
}

/**
 * i_cal_property_enum_to_string_r:
 * @e: The enum to be converted.
 *
 * Convert the enum to string.
 *
 * Returns: (transfer full): The string representation of @e.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_property_enum_to_string_r (gint e)
{
	return icalproperty_enum_to_string_r (e);
}

/**
 * i_cal_property_string_to_enum:
 * @str: A string.
 *
 * Convert the string to an enum.
 *
 * Returns: The enum corresponding to @str.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_property_string_to_enum (const gchar *str)
{
	g_return_val_if_fail (str != NULL, 0);

	return icalproperty_string_to_enum (str);
}

/**
 * i_cal_property_kind_and_string_to_enum:
 * @kind: The kind.
 * @str: A string.
 *
 * Convert a integer and string into an enum.
 *
 * Returns: The enum.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_property_kind_and_string_to_enum (const gint kind, 
                                        const gchar *str)
{
	g_return_val_if_fail (str != NULL, 0);

	return icalproperty_kind_and_string_to_enum (kind, str);
}

/**
 * i_cal_property_string_to_status:
 * @str: A string.
 *
 * Convert the string to #ICalPropertyKind.
 *
 * Returns: The #ICalPropertyStatus.
 *
 * Since: 1.0
 *
 **/
ICalPropertyStatus
i_cal_property_string_to_status (const gchar *str)
{
	g_return_val_if_fail (str != NULL, I_CAL_STATUS_NONE);

	return icalproperty_string_to_status (str);
}

/**
 * i_cal_property_status_to_string:
 * @method: The #ICalPropertyStatus.
 *
 * Convert the #ICalPropertyStatus to string.
 *
 * Returns: The string representation of #ICalPropertyStatus.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_property_status_to_string (ICalPropertyStatus method)
{
	return icalproperty_status_to_string (method);
}

/**
 * i_cal_property_enum_belongs_to_property:
 * @kind: A #ICalPropertyKind
 * @e: The enum to be checked.
 *
 * Check whether the enum belongs to the #ICalPropertyKind.
 *
 * Returns: 1 if yes, 0 if not.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_property_enum_belongs_to_property (ICalPropertyKind kind, 
                                         gint e)
{
	return icalproperty_enum_belongs_to_property (kind, e);
}
