/* Generated file (by src-generator) */

/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined (__LIBICAL_GLIB_H_INSIDE__) && !defined (LIBICAL_GLIB_COMPILATION)
#error "Only <libical-glib/libical-glib.h> can be included directly."
#endif

#ifndef I_CAL_PROPERTY_H
#define I_CAL_PROPERTY_H

#include <libical-glib/i-cal-object.h>
#include <libical-glib/i-cal-derived-parameter.h>
#include <libical-glib/i-cal-derived-value.h>
#include <libical-glib/i-cal-derived-property.h>

G_BEGIN_DECLS

#define I_CAL_PROPERTY_TYPE \
        (i_cal_property_get_type ())
#define I_CAL_PROPERTY(obj) \
        (G_TYPE_CHECK_INSTANCE_CAST \
        ((obj), I_CAL_PROPERTY_TYPE, ICalProperty))
#define I_CAL_PROPERTY_CLASS(klass) \
        (G_TYPE_CHECK_CLASS_CAST \
        ((klass), I_CAL_PROPERTY_TYPE, ICalPropertyClass))
#define I_CAL_IS_PROPERTY(obj) \
        (G_TYPE_CHECK_INSTANCE_TYPE \
        ((obj), I_CAL_PROPERTY_TYPE))
#define I_CAL_IS_PROPERTY_CLASS(klass) \
        (G_TYPE_CHECK_CLASS_TYPE \
        ((klass), I_CAL_PROPERTY_TYPE))

/**
 * ICalProperty:
 *
 * This is the ICalProperty instance.
 */
typedef struct _ICalProperty ICalProperty;

/**
 * ICalPropertyClass:
 *
 * This is the ICalProperty class.
 */
typedef struct _ICalPropertyClass ICalPropertyClass;

struct _ICalProperty {
	/*< private >*/
	ICalObject parent;
};

struct _ICalPropertyClass {
	/*< private >*/
	ICalObjectClass parent;
};

typedef struct _ICalValue ICalValue;
typedef struct _ICalParameter ICalParameter;

ICalProperty *	i_cal_property_new_full		(icalproperty *native,
						 GObject *owner);
GType 		i_cal_property_get_type		(void);
ICalProperty *	i_cal_property_new		(ICalPropertyKind kind);
ICalProperty *	i_cal_property_new_clone	(ICalProperty *prop);
ICalProperty *	i_cal_property_new_from_string	(const gchar *str);
const gchar *	i_cal_property_as_ical_string_r	(ICalProperty *prop);
void		i_cal_property_free		(ICalProperty *prop);
ICalPropertyKind 
		i_cal_property_isa		(ICalProperty *property);
gint 		i_cal_property_isa_property	(ICalProperty *property);
void		i_cal_property_add_parameter	(ICalProperty *prop,
						 ICalParameter *parameter);
void		i_cal_property_set_parameter	(ICalProperty *prop,
						 ICalParameter *parameter);
void		i_cal_property_set_parameter_from_string
						(ICalProperty *prop,
						 const gchar *name,
						 const gchar *value);
gchar *		i_cal_property_get_parameter_as_string_r
						(ICalProperty *prop,
						 const gchar *name);
void		i_cal_property_remove_parameter	(ICalProperty *prop,
						 ICalParameterKind kind);
void		i_cal_property_remove_parameter_by_kind
						(ICalProperty *prop,
						 ICalParameterKind kind);
void		i_cal_property_remove_parameter_by_name
						(ICalProperty *prop,
						 const gchar *name);
void		i_cal_property_remove_parameter_by_ref
						(ICalProperty *prop,
						 ICalParameter *param);
gint 		i_cal_property_count_parameters	(const ICalProperty *prop);
ICalParameter *	i_cal_property_get_first_parameter
						(ICalProperty *prop,
						 ICalParameterKind kind);
ICalParameter *	i_cal_property_get_next_parameter
						(ICalProperty *prop,
						 ICalParameterKind kind);
void		i_cal_property_set_value	(ICalProperty *prop,
						 ICalValue *value);
void		i_cal_property_set_value_from_string
						(ICalProperty *prop,
						 const gchar *value,
						 const gchar *kind);
ICalValue *	i_cal_property_get_value	(const ICalProperty *prop);
gchar *		i_cal_property_get_value_as_string_r
						(const ICalProperty *prop);
void		i_cal_property_set_x_name	(ICalProperty *prop,
						 const gchar *name);
const gchar *	i_cal_property_get_x_name	(ICalProperty *prop);
gchar *		i_cal_property_get_property_name_r
						(const ICalProperty *prop);
ICalValueKind 	i_cal_parameter_value_to_value_kind
						(ICalParameterValue value);
ICalValueKind 	i_cal_property_kind_to_value_kind
						(ICalPropertyKind kind);
ICalPropertyKind 
		i_cal_property_value_kind_to_kind
						(ICalValueKind kind);
const gchar *	i_cal_property_kind_to_string	(ICalPropertyKind kind);
ICalPropertyKind 
		i_cal_property_string_to_kind	(const gchar *string);
gint 		i_cal_property_kind_is_valid	(const ICalPropertyKind kind);
ICalPropertyMethod 
		i_cal_property_string_to_method	(const gchar *str);
const gchar *	i_cal_property_method_to_string	(ICalPropertyMethod method);
gchar *		i_cal_property_enum_to_string_r	(gint e);
gint 		i_cal_property_string_to_enum	(const gchar *str);
gint 		i_cal_property_kind_and_string_to_enum
						(const gint kind,
						 const gchar *str);
ICalPropertyStatus 
		i_cal_property_string_to_status	(const gchar *str);
const gchar *	i_cal_property_status_to_string	(ICalPropertyStatus method);
gint 		i_cal_property_enum_belongs_to_property
						(ICalPropertyKind kind,
						 gint e);

G_END_DECLS

#endif /* I_CAL_PROPERTY_H */
