/* Generated file (by src-generator) */

/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libical-glib/i-cal-component.h>
#include <libical-glib/libical-glib-private.h>
#include <libical-glib/i-cal-duration-type.h>
#include <libical-glib/i-cal-comp-iter.h>
#include <libical-glib/i-cal-property.h>
#include <libical-glib/i-cal-derived-value.h>
#include <libical-glib/i-cal-timetype.h>
#include <libical-glib/i-cal-enums.h>
#include <libical-glib/i-cal-time-span.h>
#include <libical-glib/i-cal-timezone.h>
#include <libical-glib/i-cal-derived-property.h>

G_DEFINE_TYPE (ICalComponent, i_cal_component, I_CAL_TYPE_OBJECT)

static void
i_cal_component_class_init (ICalComponentClass *klass)
{	
	g_type_class_add_private (klass, sizeof (ICalComponent));
}

static void
i_cal_component_init (ICalComponent *self)
{
}

/**
 * i_cal_component_new_full: (skip)
 * @native: The native libical object.
 * @owner: The parent.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 * 
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalComponent *
i_cal_component_new_full (icalcomponent *native, 
                          GObject *owner)
{
	ICalComponent *object;
	if (native == NULL)
		return NULL;
	object = g_object_new (I_CAL_COMPONENT_TYPE, NULL);
	i_cal_object_construct ((ICalObject *)object,
		        	(gpointer) native,
		        	(GDestroyNotify) icalcomponent_free,
		        	FALSE,
		        	owner);
    							
	return object;
}

/**
 * i_cal_component_new:
 * @kind: The #ICalComponentKind.
 *
 * Create a new #ICalComponent with specific type.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new (ICalComponentKind kind)
{
	return i_cal_component_new_full (icalcomponent_new (kind), NULL);
}

/**
 * i_cal_component_new_clone:
 * @component: The #ICalComponent to be created.
 *
 * Deeply clone a #ICalComponent.
 *
 * Returns: (transfer full): The newly deeply cloned #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_clone (ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);
	g_return_val_if_fail (component != NULL, NULL);

	return i_cal_component_new_full (icalcomponent_new_clone ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component))), NULL);
}

/**
 * i_cal_component_new_from_string:
 * @str: The string used to create #ICalComponent.
 *
 * Create a new #ICalComponent based on a string.
 *
 * Returns: (transfer full): The newly created #ICalComponent based on @str.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, NULL);

	return i_cal_component_new_full (icalcomponent_new_from_string (str), NULL);
}

/**
 * i_cal_component_new_x:
 * @x_name: The name of x property.
 *
 * Create a new #ICalComponent based on name of x property.
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_x (const gchar *x_name)
{
	g_return_val_if_fail (x_name != NULL, NULL);

	return i_cal_component_new_full (icalcomponent_new_x (x_name), NULL);
}

/**
 * i_cal_component_free: (skip)
 * @component: The #ICalComponent to be freed.
 *
 * Free a #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_free (ICalComponent *component)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (component));
	g_return_if_fail (component != NULL);

	icalcomponent_free ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)));
}

/**
 * i_cal_component_as_ical_string_r:
 * @component: The #ICalComponent to be converted.
 *
 * Convert a #ICalComponent to a string.
 *
 * Returns: (transfer full): The string representation of #ICalComponent.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_component_as_ical_string_r (ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);
	g_return_val_if_fail (component != NULL, NULL);

	return icalcomponent_as_ical_string_r ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)));
}

/**
 * i_cal_component_is_valid:
 * @component: The #ICalComponent to be checked.
 *
 * Check whether #ICalComponent is valid.
 *
 * Returns: 1 if yes, 0 if not.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_component_is_valid (ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), 0);
	g_return_val_if_fail (component != NULL, 0);

	return icalcomponent_is_valid ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)));
}

/**
 * i_cal_component_isa:
 * @component: The #ICalComponent to be checked.
 *
 * Get the type of #ICalComponent.
 *
 * Returns: A #ICalComponentKind.
 *
 * Since: 1.0
 *
 **/
ICalComponentKind
i_cal_component_isa (const ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), I_CAL_NO_COMPONENT);
	g_return_val_if_fail (component != NULL, I_CAL_NO_COMPONENT);

	return icalcomponent_isa ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)));
}

/**
 * i_cal_component_isa_component:
 * @component: The #ICalComponent to be checked.
 *
 * Check whether the native part of #ICalComponent is icalcomponent.
 *
 * Returns: 1 if yes, 0 if not.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_component_isa_component (ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), 0);
	g_return_val_if_fail (component != NULL, 0);

	return icalcomponent_isa_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)));
}

/**
 * i_cal_component_add_property:
 * @component: A #ICalComponent.
 * @property: A #ICalProperty.
 *
 * Add a #ICalProperty into #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_add_property (ICalComponent *component, 
                              ICalProperty *property)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (component));
	g_return_if_fail (component != NULL);
	g_return_if_fail (I_CAL_IS_PROPERTY (property));
	g_return_if_fail (property != NULL);

	i_cal_object_set_owner ((ICalObject *)property, (GObject *)component);
	icalcomponent_add_property ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), (icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (property)));
}

/**
 * i_cal_component_remove_property:
 * @component: A #ICalComponent.
 * @property: A #ICalProperty.
 *
 * Remove #ICalProperty from #ICalComponent. Caution: The compare is based on address. So you must use the
 * original #ICalProperty as the target.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_remove_property (ICalComponent *component, 
                                 ICalProperty *property)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (component));
	g_return_if_fail (component != NULL);
	g_return_if_fail (I_CAL_IS_PROPERTY (property));
	g_return_if_fail (property != NULL);

	i_cal_object_remove_owner (I_CAL_OBJECT (property));
	icalcomponent_remove_property ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), (icalproperty *)i_cal_object_get_native (I_CAL_OBJECT (property)));
}

/**
 * i_cal_component_count_properties:
 * @component: The #ICalComponent.
 * @kind: A #ICalPropertyKind.
 *
 * Count the #ICalProperty in #ICalComponent.
 *
 * Returns: The number of #ICalProperty.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_component_count_properties (ICalComponent *component, 
                                  ICalPropertyKind kind)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), 0);
	g_return_val_if_fail (component != NULL, 0);

	return icalcomponent_count_properties ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), kind);
}

/**
 * i_cal_component_get_current_property:
 * @component: A #ICalComponent.
 *
 * Get the current #ICalProperty in #ICalComponent.
 *
 * Returns: (transfer full): The current #ICalProperty.
 *
 * Since: 1.0
 *
 **/
ICalProperty *
i_cal_component_get_current_property (ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);
	g_return_val_if_fail (component != NULL, NULL);

	return i_cal_property_new_full (icalcomponent_get_current_property ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component))), (GObject *)component);
}

/**
 * i_cal_component_get_first_property:
 * @component: A #ICalComponent.
 * @kind: A #ICalPropertyKind.
 *
 * Get the first #ICalProperty with specific kind in #ICalComponent.
 *
 * Returns: (transfer full): The first #ICalProperty.
 *
 * Since: 1.0
 *
 **/
ICalProperty *
i_cal_component_get_first_property (ICalComponent *component, 
                                    ICalPropertyKind kind)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);
	g_return_val_if_fail (component != NULL, NULL);

	return i_cal_property_new_full (icalcomponent_get_first_property ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), kind), (GObject *)component);
}

/**
 * i_cal_component_get_next_property:
 * @component: A #ICalComponent.
 * @kind: A #ICalPropertyKind.
 *
 * Get the next #ICalProperty with specific kind in #ICalComponent.
 *
 * Returns: (transfer full): The next #ICalProperty.
 *
 * Since: 1.0
 *
 **/
ICalProperty *
i_cal_component_get_next_property (ICalComponent *component, 
                                   ICalPropertyKind kind)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);
	g_return_val_if_fail (component != NULL, NULL);

	return i_cal_property_new_full (icalcomponent_get_next_property ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), kind), (GObject *)component);
}

/**
 * i_cal_component_get_inner:
 * @comp: A #ICalComponent.
 *
 * Return the first VEVENT, VTODO or VJOURNAL sub-component of cop, or comp if it is one of those types.
 *
 * Returns: (transfer full): The first VEVENT, VTODO or VJOURNAL sub-component.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_get_inner (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (comp != NULL, NULL);

	return i_cal_component_new_full (icalcomponent_get_inner ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))), (GObject *)comp);
}

/**
 * i_cal_component_add_component:
 * @parent: A #ICalComponent.
 * @child: A child #ICalComponent.
 *
 * Add a #ICalComponent into another #ICalComponent as a child component.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_add_component (ICalComponent *parent, 
                               ICalComponent *child)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (parent));
	g_return_if_fail (parent != NULL);
	g_return_if_fail (I_CAL_IS_COMPONENT (child));
	g_return_if_fail (child != NULL);

	i_cal_object_set_owner ((ICalObject *)child, (GObject *)(GObject*) parent);
	icalcomponent_add_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (parent)), (icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (child)));
}

/**
 * i_cal_component_remove_component:
 * @parent: A #ICalComponent.
 * @child: A child #ICalComponent.
 *
 * Remove a child #ICalComponent from another #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_remove_component (ICalComponent *parent, 
                                  ICalComponent *child)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (parent));
	g_return_if_fail (parent != NULL);
	g_return_if_fail (I_CAL_IS_COMPONENT (child));
	g_return_if_fail (child != NULL);

	i_cal_object_remove_owner (I_CAL_OBJECT (child));
	icalcomponent_remove_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (parent)), (icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (child)));
}

/**
 * i_cal_component_count_components:
 * @component: The #ICalComponent to be checked.
 * @kind: The target #ICalComponentKind
 *
 * Count the child #ICalComponent with the target kind in the parent one.
 *
 * Returns: The count of child #ICalComponent in the parent one.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_component_count_components (ICalComponent *component, 
                                  ICalComponentKind kind)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), 0);
	g_return_val_if_fail (component != NULL, 0);

	return icalcomponent_count_components ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), kind);
}

/**
 * i_cal_component_merge_component:
 * @comp: The #ICalComponent.
 * @comp_to_merge: (in): A #ICalComponent. After merged it will not exist any more.
 *
 * This takes 2 VCALENDAR components and merges the second one into the first, resolving any problems with
 * conflicting TZIDs. comp_to_merge will no longer exist after calling this function.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_merge_component (ICalComponent *comp, 
                                 ICalComponent *comp_to_merge)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);
	g_return_if_fail (I_CAL_IS_COMPONENT (comp_to_merge));
	g_return_if_fail (comp_to_merge != NULL);

	icalcomponent_merge_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), (icalcomponent *)i_cal_object_steal_native (I_CAL_OBJECT (comp_to_merge)));
}

/**
 * i_cal_component_get_current_component:
 * @component: A #ICalComponent.
 *
 * Get the current #ICalComponent in #ICalComponent.
 *
 * Returns: (transfer full): The current #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_get_current_component (ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);
	g_return_val_if_fail (component != NULL, NULL);

	return i_cal_component_new_full (icalcomponent_get_current_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component))), (GObject *)component);
}

/**
 * i_cal_component_get_first_component:
 * @component: A #ICalComponent.
 * @kind: A #ICalComponentKind.
 *
 * Get the first #ICalComponent with specific kind in #ICalComponent.
 *
 * Returns: (transfer full): The first #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_get_first_component (ICalComponent *component, 
                                     ICalComponentKind kind)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);
	g_return_val_if_fail (component != NULL, NULL);

	return i_cal_component_new_full (icalcomponent_get_first_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), kind), (GObject *)component);
}

/**
 * i_cal_component_get_next_component:
 * @component: A #ICalComponent.
 * @kind: A #ICalComponentKind.
 *
 * Get the next #ICalComponent with specific kind in #ICalComponent.
 *
 * Returns: (transfer full): The next #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_get_next_component (ICalComponent *component, 
                                    ICalComponentKind kind)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);
	g_return_val_if_fail (component != NULL, NULL);

	return i_cal_component_new_full (icalcomponent_get_next_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), kind), (GObject *)component);
}

/**
 * i_cal_component_begin_component:
 * @component: A #ICalComponent.
 * @kind: A #ICalComponentKind.
 *
 * Get the #ICalCompIter pointing to the first child #ICalComponent. Use #ICalCompIter when you need remove
 * the child component from the parent. For traversing, i_cal_object_set_owner needs to be called after
 * this API. See component.py in tests for details.
 *
 * Returns: (transfer full): A #ICalCompIter
 *
 * Since: 1.0
 *
 **/
ICalCompIter *
i_cal_component_begin_component (ICalComponent *component, 
                                 ICalComponentKind kind)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);
	g_return_val_if_fail (component != NULL, NULL);

	return i_cal_comp_iter_new_full (icalcomponent_begin_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), kind));
}

/**
 * i_cal_component_end_component:
 * @component: A #ICalComponent.
 * @kind: A #ICalComponentKind.
 *
 * Get the #ICalCompIter pointing to the end child #ICalComponent. Use #ICalCompIter when you need remove
 * the child component from the parent. For traversing, i_cal_object_set_owner needs to be called after
 * this API. See component.py in tests for details.
 *
 * Returns: (transfer full): A #ICalCompIter
 *
 * Since: 1.0
 *
 **/
ICalCompIter *
i_cal_component_end_component (ICalComponent *component, 
                               ICalComponentKind kind)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);
	g_return_val_if_fail (component != NULL, NULL);

	return i_cal_comp_iter_new_full (icalcomponent_end_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)), kind));
}

/**
 * i_cal_comp_iter_next:
 * @i: A #ICalCompIter.
 *
 * Get the next #ICalComponent pointed by #ICalCompIter. Use #ICalCompIter when you need remove the child
 * component from the parent. For traversing, i_cal_object_set_owner needs to be called after this API.
 * See component.py in tests for details.
 *
 * Returns: (transfer full): A #ICalCompIter
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_comp_iter_next (ICalCompIter *i)
{
	g_return_val_if_fail (I_CAL_IS_COMP_ITER (i), NULL);
	g_return_val_if_fail (i != NULL, NULL);

	return i_cal_component_new_full (icalcompiter_next ((struct icalcompiter *)i_cal_object_get_native (I_CAL_OBJECT (i))), NULL);
}

/**
 * i_cal_comp_iter_prior:
 * @i: A #ICalCompIter.
 *
 * Get the prior #ICalComponent pointed by #ICalCompIter. Use #ICalCompIter when you need remove the child
 * component from the parent. For traversing, i_cal_object_set_owner needs to be called after this API.
 * See component.py in tests for details.
 *
 * Returns: (transfer full): A #ICalCompIter
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_comp_iter_prior (ICalCompIter *i)
{
	g_return_val_if_fail (I_CAL_IS_COMP_ITER (i), NULL);
	g_return_val_if_fail (i != NULL, NULL);

	return i_cal_component_new_full (icalcompiter_prior ((struct icalcompiter *)i_cal_object_get_native (I_CAL_OBJECT (i))), NULL);
}

/**
 * i_cal_comp_iter_deref:
 * @i: A #ICalCompIter.
 *
 * Get the current #ICalComponent pointed by #ICalCompIter. Use #ICalCompIter when you need remove the child
 * component from the parent. For traversing, i_cal_object_set_owner needs to be called after this API.
 * See component.py in tests for details.
 *
 * Returns: (transfer full): A #ICalComponent
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_comp_iter_deref (ICalCompIter *i)
{
	g_return_val_if_fail (I_CAL_IS_COMP_ITER (i), NULL);
	g_return_val_if_fail (i != NULL, NULL);

	return i_cal_component_new_full (icalcompiter_deref ((struct icalcompiter *)i_cal_object_get_native (I_CAL_OBJECT (i))), NULL);
}

/**
 * i_cal_component_check_restrictions:
 * @comp: The #ICalComponent to be checked
 *
 * Check the number of restrictions in #ICalComponent
 *
 * Returns: The number of restrictions in @comp
 *
 * Since: 1.0
 *
 **/
gint
i_cal_component_check_restrictions (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), 0);
	g_return_val_if_fail (comp != NULL, 0);

	return icalcomponent_check_restrictions ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_count_errors:
 * @comp: A #ICalComponent
 *
 * Count the number of errors in #ICalComponent.
 *
 * Returns: The count of errors.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_component_count_errors (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), 0);
	g_return_val_if_fail (comp != NULL, 0);

	return icalcomponent_count_errors ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_strip_errors:
 * @comp: A #ICalComponent
 *
 * Remove all X-LIC-ERROR properties.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_strip_errors (ICalComponent *comp)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);

	icalcomponent_strip_errors ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_convert_errors:
 * @comp: A #ICalComponent
 *
 * Convert some X-LIC-ERROR properties into RETURN-STATUS properties.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_convert_errors (ICalComponent *comp)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);

	icalcomponent_convert_errors ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_kind_is_valid:
 * @kind: A #ICalComponentKind.
 *
 * Check if a #ICalComponentKind is valid.
 *
 * Returns: 1 if @kind id a #ICalComponent but not the I_CAL_NO_COMPONENT, 0 if not.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_component_kind_is_valid (const ICalComponentKind kind)
{
	return icalcomponent_kind_is_valid (kind);
}

/**
 * i_cal_component_string_to_kind:
 * @string: A string.
 *
 * Convert a string to a #ICalComponentKind.
 *
 * Returns: A #ICalComponentKind
 *
 * Since: 1.0
 *
 **/
ICalComponentKind
i_cal_component_string_to_kind (const gchar *string)
{
	g_return_val_if_fail (string != NULL, I_CAL_NO_COMPONENT);

	return icalcomponent_string_to_kind (string);
}

/**
 * i_cal_component_kind_to_string:
 * @kind: A #ICalComponentKind.
 *
 * Convert a #ICalComponentKind to a string.
 *
 * Returns: (transfer none): The string representation of @kind.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_component_kind_to_string (ICalComponentKind kind)
{
	return icalcomponent_kind_to_string (kind);
}

/**
 * i_cal_component_get_first_real_component:
 * @c: A VCOMPONENT type of #ICalComponent.
 *
 * For VCOMPONENT: Return a reference to the first VEVENT, VTODO or VJOURNAL.
 *
 * Returns: (transfer full): A reference to the first VEVENT, VTODO or VJOURNAL
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_get_first_real_component (ICalComponent *c)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (c), NULL);
	g_return_val_if_fail (c != NULL, NULL);

	return i_cal_component_new_full (icalcomponent_get_first_real_component ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (c))), (GObject *)c);
}

/**
 * i_cal_component_get_span:
 * @comp: A #ICalComponent
 *
 * For VEVENT, VTODO, VJOURNAL and VTIMEZONE: report the start and end times of an event in UTC
 *
 * Returns: (transfer full): A #ICalTimeSpan.
 *
 * Since: 1.0
 *
 **/
ICalTimeSpan *
i_cal_component_get_span (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (comp != NULL, NULL);

	return i_cal_time_span_new_full (icalcomponent_get_span ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_set_dtstart:
 * @comp: A #ICalComponent.
 * @v: A #ICalTimetype.
 *
 * Set the dtstart of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_dtstart (ICalComponent *comp, 
                             ICalTimetype *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);
	g_return_if_fail (I_CAL_IS_TIMETYPE (v));
	g_return_if_fail (v != NULL);

	icalcomponent_set_dtstart ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), * (struct icaltimetype *) i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_component_get_dtstart:
 * @comp: A #ICalComponent.
 *
 * Get the dtstart of the #ICalComponent.
 *
 * Returns: (transfer full): A #ICalTimetype.
 *
 * Since: 1.0
 *
 **/
ICalTimetype *
i_cal_component_get_dtstart (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (comp != NULL, NULL);

	return i_cal_timetype_new_full (icalcomponent_get_dtstart ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_set_dtend:
 * @comp: A #ICalComponent.
 * @v: A #ICalTimetype.
 *
 * Set the dtend of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_dtend (ICalComponent *comp, 
                           ICalTimetype *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);
	g_return_if_fail (I_CAL_IS_TIMETYPE (v));
	g_return_if_fail (v != NULL);

	icalcomponent_set_dtend ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), * (struct icaltimetype *) i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_component_get_dtend:
 * @comp: A #ICalComponent.
 *
 * Get the dtend of the #ICalComponent.
 *
 * Returns: (transfer full): A #ICalTimetype.
 *
 * Since: 1.0
 *
 **/
ICalTimetype *
i_cal_component_get_dtend (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (comp != NULL, NULL);

	return i_cal_timetype_new_full (icalcomponent_get_dtend ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_set_due:
 * @comp: A #ICalComponent.
 * @v: A #ICalTimetype.
 *
 * Set the due of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_due (ICalComponent *comp, 
                         ICalTimetype *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);
	g_return_if_fail (I_CAL_IS_TIMETYPE (v));
	g_return_if_fail (v != NULL);

	icalcomponent_set_due ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), * (struct icaltimetype *) i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_component_get_due:
 * @comp: A #ICalComponent.
 *
 * Get the due of the #ICalComponent.
 *
 * Returns: (transfer full): A #ICalTimetype.
 *
 * Since: 1.0
 *
 **/
ICalTimetype *
i_cal_component_get_due (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (comp != NULL, NULL);

	return i_cal_timetype_new_full (icalcomponent_get_due ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_set_duration:
 * @comp: A #ICalComponent.
 * @v: A #ICalDurationType.
 *
 * Set the duration of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_duration (ICalComponent *comp, 
                              ICalDurationType *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);
	g_return_if_fail (I_CAL_IS_DURATION_TYPE (v));
	g_return_if_fail (v != NULL);

	icalcomponent_set_duration ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), * (struct icaldurationtype *) i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_component_get_duration:
 * @comp: A #ICalComponent.
 *
 * Get the duration of the #ICalComponent.
 *
 * Returns: (transfer full): A #ICalDurationType.
 *
 * Since: 1.0
 *
 **/
ICalDurationType *
i_cal_component_get_duration (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (comp != NULL, NULL);

	return i_cal_duration_type_new_full (icalcomponent_get_duration ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_set_method:
 * @comp: A #ICalComponent.
 * @method: A #ICalPropertyMethod.
 *
 * Set the method of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_method (ICalComponent *comp, 
                            ICalPropertyMethod method)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);

	icalcomponent_set_method ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), method);
}

/**
 * i_cal_component_get_method:
 * @comp: A #ICalComponent.
 *
 * Get the method of the #ICalComponent.
 *
 * Returns: A #ICalPropertyMethod.
 *
 * Since: 1.0
 *
 **/
ICalPropertyMethod
i_cal_component_get_method (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), I_CAL_METHOD_NONE);
	g_return_val_if_fail (comp != NULL, I_CAL_METHOD_NONE);

	return icalcomponent_get_method ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_set_dtstamp:
 * @comp: A #ICalComponent.
 * @v: A #ICalTimetype.
 *
 * Set the dtstamp of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_dtstamp (ICalComponent *comp, 
                             ICalTimetype *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);
	g_return_if_fail (I_CAL_IS_TIMETYPE (v));
	g_return_if_fail (v != NULL);

	icalcomponent_set_dtstamp ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), * (struct icaltimetype *) i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_component_get_dtstamp:
 * @comp: A #ICalComponent.
 *
 * Get the dtstamp of the #ICalComponent.
 *
 * Returns: (transfer full): A #ICalTimetype.
 *
 * Since: 1.0
 *
 **/
ICalTimetype *
i_cal_component_get_dtstamp (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (comp != NULL, NULL);

	return i_cal_timetype_new_full (icalcomponent_get_dtstamp ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_set_summary:
 * @comp: A #ICalComponent.
 * @v: A string representing summary.
 *
 * Set the summary of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_summary (ICalComponent *comp, 
                             const gchar *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);
	g_return_if_fail (v != NULL);

	icalcomponent_set_summary ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), v);
}

/**
 * i_cal_component_get_summary:
 * @comp: A #ICalComponent.
 *
 * Get the summary of the #ICalComponent.
 *
 * Returns: (transfer none): The summary of @comp.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_component_get_summary (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (comp != NULL, NULL);

	return icalcomponent_get_summary ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_set_comment:
 * @comp: A #ICalComponent.
 * @v: A string representing comment.
 *
 * Set the comment of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_comment (ICalComponent *comp, 
                             const gchar *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);
	g_return_if_fail (v != NULL);

	icalcomponent_set_comment ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), v);
}

/**
 * i_cal_component_get_comment:
 * @comp: A #ICalComponent.
 *
 * Get the comment of the #ICalComponent.
 *
 * Returns: (transfer none): The comment of @comp.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_component_get_comment (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (comp != NULL, NULL);

	return icalcomponent_get_comment ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_set_uid:
 * @comp: A #ICalComponent.
 * @v: A string representing uid.
 *
 * Set the uid of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_uid (ICalComponent *comp, 
                         const gchar *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);
	g_return_if_fail (v != NULL);

	icalcomponent_set_uid ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), v);
}

/**
 * i_cal_component_get_uid:
 * @comp: A #ICalComponent.
 *
 * Get the uid of the #ICalComponent.
 *
 * Returns: (transfer none): The uid of @comp.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_component_get_uid (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (comp != NULL, NULL);

	return icalcomponent_get_uid ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_set_relcalid:
 * @comp: A #ICalComponent.
 * @v: A string representing relcalid.
 *
 * Set the relcalid of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_relcalid (ICalComponent *comp, 
                              const gchar *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);
	g_return_if_fail (v != NULL);

	icalcomponent_set_relcalid ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), v);
}

/**
 * i_cal_component_get_relcalid:
 * @comp: A #ICalComponent.
 *
 * Get the relcalid of the #ICalComponent.
 *
 * Returns: (transfer none): The relcalid of @comp.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_component_get_relcalid (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (comp != NULL, NULL);

	return icalcomponent_get_relcalid ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_set_recurrenceid:
 * @comp: A #ICalComponent.
 * @v: A #ICalTimetype.
 *
 * Set the recurrenceid of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_recurrenceid (ICalComponent *comp, 
                                  ICalTimetype *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);
	g_return_if_fail (I_CAL_IS_TIMETYPE (v));
	g_return_if_fail (v != NULL);

	icalcomponent_set_recurrenceid ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), * (struct icaltimetype *) i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_component_get_recurrenceid:
 * @comp: A #ICalComponent.
 *
 * Get the recurrenceid of the #ICalComponent.
 *
 * Returns: (transfer full): A #ICalTimetype.
 *
 * Since: 1.0
 *
 **/
ICalTimetype *
i_cal_component_get_recurrenceid (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (comp != NULL, NULL);

	return i_cal_timetype_new_full (icalcomponent_get_recurrenceid ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp))));
}

/**
 * i_cal_component_set_description:
 * @comp: A #ICalComponent.
 * @v: A string representing description.
 *
 * Set the description of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_description (ICalComponent *comp, 
                                 const gchar *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);
	g_return_if_fail (v != NULL);

	icalcomponent_set_description ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), v);
}

/**
 * i_cal_component_get_description:
 * @comp: A #ICalComponent.
 *
 * Get the description of the #ICalComponent.
 *
 * Returns: (transfer none): The description of @comp.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_component_get_description (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (comp != NULL, NULL);

	return icalcomponent_get_description ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_set_location:
 * @comp: A #ICalComponent.
 * @v: A string representing location.
 *
 * Set the location of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_location (ICalComponent *comp, 
                              const gchar *v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);
	g_return_if_fail (v != NULL);

	icalcomponent_set_location ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), v);
}

/**
 * i_cal_component_get_location:
 * @comp: A #ICalComponent.
 *
 * Get the location of the #ICalComponent.
 *
 * Returns: (transfer none): The location of @comp.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_component_get_location (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (comp != NULL, NULL);

	return icalcomponent_get_location ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_set_sequence:
 * @comp: A #ICalComponent.
 * @v: The sequence number.
 *
 * Set the sequence of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_sequence (ICalComponent *comp, 
                              gint v)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);

	icalcomponent_set_sequence ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), v);
}

/**
 * i_cal_component_get_sequence:
 * @comp: A #ICalComponent.
 *
 * Get the sequence of the #ICalComponent.
 *
 * Returns: The sequence of @comp.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_component_get_sequence (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), 0);
	g_return_val_if_fail (comp != NULL, 0);

	return icalcomponent_get_sequence ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_set_status:
 * @comp: A #ICalComponent.
 * @status: A #ICalPropertyStatus.
 *
 * Set the status of the #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_set_status (ICalComponent *comp, 
                            ICalPropertyStatus status)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (comp != NULL);

	icalcomponent_set_status ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), status);
}

/**
 * i_cal_component_get_status:
 * @comp: A #ICalComponent.
 *
 * Get the status of the #ICalComponent.
 *
 * Returns: A #ICalPropertyStatus.
 *
 * Since: 1.0
 *
 **/
ICalPropertyStatus
i_cal_component_get_status (ICalComponent *comp)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), I_CAL_STATUS_NONE);
	g_return_val_if_fail (comp != NULL, I_CAL_STATUS_NONE);

	return icalcomponent_get_status ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_component_foreach_tzid: (skip)
 * @comp: The #ICalComponent to be queried.
 *  @callback: The callback function.
 * @callback_data: (allow-none): The data for callback function
 *
 * Apply the same manipulation on every tzid in #ICalComponent. It cannot be used by Python yet. For convenience,
 * a python version of this API is defined in tests/component.py.
 *
 * Since: 1.0
 *
 **/
void
i_cal_component_foreach_tzid (ICalComponent *comp, 
                              void (*callback)(ICalParameter *param, void *data), 
                              void *callback_data)
{
	ICalProperty *prop;
	ICalPropertyKind kind;
	ICalParameter *param;
	ICalComponent *subcomp;
    		
	g_return_if_fail (comp != NULL && I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (callback != NULL);
	
	/* First look for any TZID parameters used in this component itself. */
	prop = i_cal_component_get_first_property (comp, I_CAL_ANY_PROPERTY);
	while (prop) {
		kind = i_cal_property_isa (prop);
		
		/* These are the only properties that can have a TZID. Note that
		COMPLETED, CREATED, DTSTAMP and LASTMODIFIED must be in UTC. */
		if (kind == I_CAL_DTSTART_PROPERTY || kind == I_CAL_DTEND_PROPERTY
		 || kind == I_CAL_DUE_PROPERTY || kind == I_CAL_EXDATE_PROPERTY
		 || kind == I_CAL_RDATE_PROPERTY) {
			param = i_cal_property_get_first_parameter (prop, I_CAL_TZID_PARAMETER);
				
			if (param)
			    (*callback) (param, callback_data);
		}
			
		prop = i_cal_component_get_next_property (comp, I_CAL_ANY_PROPERTY);
	}
	
	/* Now recursively check child components. */
	subcomp = i_cal_component_get_first_component (comp, I_CAL_ANY_COMPONENT);
	while (subcomp) {
	    i_cal_component_foreach_tzid (subcomp, callback, callback_data);
	    subcomp = i_cal_component_get_next_component (comp, ICAL_ANY_COMPONENT);
	}
}

/**
 * i_cal_component_get_timezone:
 * @comp: A #ICalComponent.
 * @tzid: A string representing timezone.
 *
 * Returns the icaltimezone in the component corresponding to the TZID, or NULL if it can't be found.
 *
 * Returns: (transfer full) (allow-none): A #ICalTimezone.
 *
 * Since: 1.0
 *
 **/
ICalTimezone *
i_cal_component_get_timezone (ICalComponent *comp, 
                              const gchar *tzid)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), NULL);
	g_return_val_if_fail (comp != NULL, NULL);
	g_return_val_if_fail (tzid != NULL, NULL);

	return i_cal_timezone_new_full (icalcomponent_get_timezone ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), tzid), (GObject *)comp, FALSE);
}

/**
 * i_cal_property_recurrence_is_excluded:
 * @comp: A #ICalComponent.
 * @dtstart: The base dtstart value for this component.
 * @recurtime: The time to test against.
 *
 * Decide if this recurrance is acceptable. This function decides if a specific recurrence value is excluded
 * by EXRULE or EXDATE properties.
 *
 * Returns: 1 if yes, 0 if not.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_property_recurrence_is_excluded (ICalComponent *comp, 
                                       ICalTimetype *dtstart, 
                                       ICalTimetype *recurtime)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (comp), 0);
	g_return_val_if_fail (comp != NULL, 0);
	g_return_val_if_fail (I_CAL_IS_TIMETYPE (dtstart), 0);
	g_return_val_if_fail (dtstart != NULL, 0);
	g_return_val_if_fail (I_CAL_IS_TIMETYPE (recurtime), 0);
	g_return_val_if_fail (recurtime != NULL, 0);

	return icalproperty_recurrence_is_excluded ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (dtstart)), (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (recurtime)));
}

/**
 * i_cal_component_new_vcalendar:
 *
 * Create a #ICalComponent with the type to be vcalendar
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vcalendar (void)
{
	return i_cal_component_new_full (icalcomponent_new_vcalendar (), NULL);
}

/**
 * i_cal_component_new_vevent:
 *
 * Create a #ICalComponent with the type to be vevent
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vevent (void)
{
	return i_cal_component_new_full (icalcomponent_new_vevent (), NULL);
}

/**
 * i_cal_component_new_vtodo:
 *
 * Create a #ICalComponent with the type to be vtodo
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vtodo (void)
{
	return i_cal_component_new_full (icalcomponent_new_vtodo (), NULL);
}

/**
 * i_cal_component_new_vjournal:
 *
 * Create a #ICalComponent with the type to be vjournal
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vjournal (void)
{
	return i_cal_component_new_full (icalcomponent_new_vjournal (), NULL);
}

/**
 * i_cal_component_new_valarm:
 *
 * Create a #ICalComponent with the type to be valarm
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_valarm (void)
{
	return i_cal_component_new_full (icalcomponent_new_valarm (), NULL);
}

/**
 * i_cal_component_new_vfreebusy:
 *
 * Create a #ICalComponent with the type to be vfreebusy
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vfreebusy (void)
{
	return i_cal_component_new_full (icalcomponent_new_vfreebusy (), NULL);
}

/**
 * i_cal_component_new_vtimezone:
 *
 * Create a #ICalComponent with the type to be vtimezone
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vtimezone (void)
{
	return i_cal_component_new_full (icalcomponent_new_vtimezone (), NULL);
}

/**
 * i_cal_component_new_xstandard:
 *
 * Create a #ICalComponent with the type to be xstandard
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_xstandard (void)
{
	return i_cal_component_new_full (icalcomponent_new_xstandard (), NULL);
}

/**
 * i_cal_component_new_xdaylight:
 *
 * Create a #ICalComponent with the type to be xdaylight
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_xdaylight (void)
{
	return i_cal_component_new_full (icalcomponent_new_xdaylight (), NULL);
}

/**
 * i_cal_component_new_vagenda:
 *
 * Create a #ICalComponent with the type to be vagenda
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vagenda (void)
{
	return i_cal_component_new_full (icalcomponent_new_vagenda (), NULL);
}

/**
 * i_cal_component_new_vquery:
 *
 * Create a #ICalComponent with the type to be vquery
 *
 * Returns: (transfer full): The newly created #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_component_new_vquery (void)
{
	return i_cal_component_new_full (icalcomponent_new_vquery (), NULL);
}
