/* Generated file (by src-generator) */

/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libical-glib/i-cal-memory.h>
#include <libical-glib/libical-glib-private.h>

/**
 * i_cal_memory_tmp_buffer:
 * @size: The size of the buffer to be created.
 *
 * Create a buffer with target size.
 *
 * Returns: (transfer full): The newly created buffer
 *
 * Since: 1.0
 *
 **/
void *
i_cal_memory_tmp_buffer (size_t size)
{
	return icalmemory_tmp_buffer (size);
}

/**
 * i_cal_memory_tmp_copy:
 * @str: The string to be copied
 *
 * Like strdup, but the buffer is on the ring.
 *
 * Returns: (transfer full): The new copy of the @str.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_memory_tmp_copy (const gchar *str)
{
	g_return_val_if_fail (str != NULL, NULL);

	return icalmemory_tmp_copy (str);
}

/**
 * i_cal_memory_add_tmp_buffer:
 * @buf: (transfer full): The existing buffer to be added into the ical
 *
 * Add an existing buffer to the buffer ring
 *
 * Since: 1.0
 *
 **/
void
i_cal_memory_add_tmp_buffer (void *buf)
{
	g_return_if_fail (buf != NULL);

	icalmemory_add_tmp_buffer (buf);
}

/**
 * i_cal_memory_free_ring: (skip)
 *
 * Free all the memory used in the ring.
 *
 * Since: 1.0
 *
 **/
void
i_cal_memory_free_ring (void)
{
	icalmemory_free_ring ();
}

/**
 * i_cal_memory_new_buffer:
 * @size: The size of the new buffer to be created.
 *
 * Create a new buffer with target size. The caller should deallocate it when necessary.
 *
 * Returns: (transfer full): The newly created buffer with the target size.
 *
 * Since: 1.0
 *
 **/
void *
i_cal_memory_new_buffer (size_t size)
{
	return icalmemory_new_buffer (size);
}

/**
 * i_cal_memory_resize_buffer:
 * @buf: (transfer full): The buffer needs to be resized.
 * @size: The target size the buffer to be resized to.
 *
 * Resize the buffer to the target size.
 *
 * Returns: (transfer full): The buffer after being resized.
 *
 * Since: 1.0
 *
 **/
void *
i_cal_memory_resize_buffer (void *buf, 
                            size_t size)
{
	g_return_val_if_fail (buf != NULL, NULL);

	return icalmemory_resize_buffer (buf, size);
}

/**
 * i_cal_memory_free_buffer:
 * @buf: (transfer full): The buffer to be freed.
 *
 * Free the buffer.
 *
 * Since: 1.0
 *
 **/
void
i_cal_memory_free_buffer (void *buf)
{
	g_return_if_fail (buf != NULL);

	icalmemory_free_buffer (buf);
}

/**
 * i_cal_memory_append_string:
 * @buf: The buffer to be appended. It should not be the memory in ical.
 * @pos: The position at which the new string to be appended.
 * @buf_size: THe size of the buffer before appended
 * @string: The string to be allocated
 *
 * Append the string to the buffer. Only use them on normally allocated memory, or on buffers created from
 * icalmemory_new_buffer, never with buffers created by icalmemory_tmp_buffer. If icalmemory_append_string
 * has to resize a buffer on the ring, the ring will loose track of it an you will have memory problems.
 *
 * Since: 1.0
 *
 **/
void
i_cal_memory_append_string (gchar **buf, 
                            gchar **pos, 
                            size_t *buf_size, 
                            const gchar *string)
{
	g_return_if_fail (buf != NULL);
	g_return_if_fail (pos != NULL);
	g_return_if_fail (buf_size != NULL);
	g_return_if_fail (string != NULL);

	icalmemory_append_string (buf, pos, buf_size, string);
}

/**
 * i_cal_memory_append_char:
 * @buf: The buffer to be appended. It should not be the memory in ical.
 * @pos: The position at which the new string to be appended.
 * @buf_size: THe size of the buffer before appended
 * @ch: The character to be allocated
 *
 * Append the character to the buffer. Only use them on normally allocated memory, or on buffers created
 * from icalmemory_new_buffer, never with buffers created by icalmemory_tmp_buffer. If icalmemory_append_string
 * has to resize a buffer on the ring, the ring will loose track of it an you will have memory problems.
 *
 * Since: 1.0
 *
 **/
void
i_cal_memory_append_char (gchar **buf, 
                          gchar **pos, 
                          size_t *buf_size, 
                          gchar ch)
{
	g_return_if_fail (buf != NULL);
	g_return_if_fail (pos != NULL);
	g_return_if_fail (buf_size != NULL);

	icalmemory_append_char (buf, pos, buf_size, ch);
}

/**
 * i_cal_memory_strdup:
 * @s: The string to be cloned.
 *
 * A wrapper around strdup. Partly to trap calls to strdup, partly because in -ansi, gcc on Red Hat claims
 * that strdup is undeclared
 *
 * Returns: (transfer full): The cloned string.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_memory_strdup (const gchar *s)
{
	g_return_val_if_fail (s != NULL, NULL);

	return icalmemory_strdup (s);
}
