/* Generated file (by src-generator) */

/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-recur.h"
#include "libical-glib-private.h"
#include "i-cal-recurrence-type.h"

/**
 * i_cal_recur_expand_recurrence:
 * @rule: The rule of the recurrence.
 * @start: the start seconds past the POSIX epoch.
 * @count: The number of elements to be filled up in the @array.
 *
 * Fill an array with the 'count' number of occurrences generated by the rrule. Note that the times are
 * returned in UTC, but the times are calculated in local time. YOu will have to convert the results back
 * into local time before using them.
 *
 * Returns: (array) (element-type long) (transfer full): If successful, return the array. NULL if failed.
 *
 * Since: 1.0
 *
 **/
GArray *
i_cal_recur_expand_recurrence (gchar *rule, 
                               time_t start, 
                               gint count)
{
	time_t *array;
	GArray *garray;
	gint result;
	g_return_val_if_fail (rule != NULL, 0);
	array = g_new (time_t, count);
	result = icalrecur_expand_recurrence (rule, start, count, array);
	if (result == 0) {
		g_free (array);
		return NULL;
	} else {
		garray = g_array_new (FALSE, FALSE, sizeof (time_t));
		g_array_append_vals (garray, array, count);
		return garray;
	}
}

/**
 * i_cal_recur_string_to_weekday:
 * @str: The string representation of the weekday.
 *
 * Convert a string representation to an enum representation for the weekday.
 *
 * Returns: The enum representation of the weekday.
 *
 * Since: 1.0
 *
 **/
ICalRecurrenceTypeWeekday
i_cal_recur_string_to_weekday (const gchar *str)
{
	g_return_val_if_fail (str != NULL, I_CAL_NO_WEEKDAY);

	return icalrecur_string_to_weekday (str);
}
