/* Generated file (by src-generator) */

/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-timezone-phase.h"
#include "libical-glib-private.h"
#include "i-cal-timetype.h"
#include "i-cal-datetimeperiod-type.h"

G_DEFINE_TYPE (ICalTimezonePhase, i_cal_timezone_phase, I_CAL_TYPE_OBJECT)

static void
i_cal_timezone_phase_class_init (ICalTimezonePhaseClass *klass)
{	
	g_type_class_add_private (klass, sizeof (ICalTimezonePhase));
}

static void
i_cal_timezone_phase_init (ICalTimezonePhase *self)
{
}

/**
 * i_cal_timezone_phase_new_full: (skip)
 * @native: The native libical object.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 * 
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalTimezonePhase *
i_cal_timezone_phase_new_full (struct icaltimezonephase native)
{
	ICalTimezonePhase *object;
	struct icaltimezonephase *clone;
	object = g_object_new (I_CAL_TIMEZONE_PHASE_TYPE, NULL);
	clone = g_new (struct icaltimezonephase, 1);
	*clone = native;
	i_cal_object_construct ((ICalObject *)object,
		        	(gpointer) clone,
		        	(GDestroyNotify) g_free,
		        	FALSE,
		        	NULL);
    							
	return object;
}

/**
 * i_cal_timezone_phase_new_default:
 *
 * Create a new default #ICalTimezonePhase
 *
 * Returns: (transfer full): The newly created #ICalTimezonePhase
 *
 * Since: 1.0
 *
 **/
struct icaltimezonephase
i_cal_timezone_phase_new_default (void)
{
	struct icaltimezonephase timezonephase;
	timezonephase.is_stdandard = 1;
	timezonephase.dtstart = i_cal_timetype_new_default ();
	timezonephase.offsetto = 0;
	timezonephase.tzoffsetfrom = 0;
	timezonephase.rdate = i_cal_datetimeperiod_type_new_default ();
	return timezonephase;
}

/**
 * i_cal_timezone_phase_get_tzname:
 * @phase: The #ICalTimezonePhase.
 *
 * Get the tzname of #ICalTimezonePhase.
 *
 * Returns: (transfer none): The tzname of @phase.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_timezone_phase_get_tzname (ICalTimezonePhase *phase)
{
	g_return_val_if_fail (phase != NULL && I_CAL_IS_TIMEZONE_PHASE (phase), NULL);
	return ((struct icaltimezonephase *)i_cal_object_get_native ((ICalObject *)phase))->tzname;
}

/**
 * i_cal_timezone_phase_is_stdandard:
 * @phase: The #ICalTimezonePhase.
 *
 * Get the is_stdandard of #ICalTimezonePhase.
 *
 * Returns: (transfer none): The is_stdandard of @phase.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_timezone_phase_is_stdandard (ICalTimezonePhase *phase)
{
	g_return_val_if_fail (phase != NULL && I_CAL_IS_TIMEZONE_PHASE (phase), FALSE);
	return ((struct icaltimezonephase *)i_cal_object_get_native ((ICalObject *)phase))->is_stdandard;
}

/**
 * i_cal_timezone_phase_set_is_stdandard:
 * @phase: The #ICalTimezonePhase.
 * @is_stdandard: The is_stdandard.
 *
 * Set the is_stdandard of #ICalTimezonePhase.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezone_phase_set_is_stdandard (ICalTimezonePhase *phase, 
                                       gint is_stdandard)
{
	g_return_if_fail (phase != NULL && I_CAL_IS_TIMEZONE_PHASE (phase));
	((struct icaltimezonephase *)i_cal_object_get_native ((ICalObject *)phase))->is_stdandard = is_stdandard;
}

/**
 * i_cal_timezone_phase_get_dtstart:
 * @phase: The #ICalTimezonePhase.
 *
 * Get the dtstart from #ICalTimezonePhase.
 *
 * Returns: (transfer full): The dtstart of #ICalTimezonePhase.
 *
 * Since: 1.0
 *
 **/
ICalTimetype *
i_cal_timezone_phase_get_dtstart (ICalTimezonePhase *phase)
{
	g_return_val_if_fail (phase != NULL && I_CAL_IS_TIMEZONE_PHASE (phase), NULL);
	return i_cal_timetype_new_full (((struct icaltimezonephase *)i_cal_object_get_native ((ICalObject *)phase))->dtstart);
}

/**
 * i_cal_timezone_phase_set_dtstart:
 * @phase: The #ICalTimezonePhase.
 * @dtstart: The dtstart of #ICalTimezonePhase.
 *
 * Set the dtstart from #ICalTimezonePhase.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezone_phase_set_dtstart (ICalTimezonePhase *phase, 
                                  ICalTimetype *dtstart)
{
	g_return_if_fail (phase != NULL && I_CAL_IS_TIMEZONE_PHASE (phase));
    g_return_if_fail (dtstart != NULL && I_CAL_IS_TIMETYPE (dtstart));
	((struct icaltimezonephase *)i_cal_object_get_native ((ICalObject *)phase))->dtstart = *(struct icaltimetype *)i_cal_object_get_native ((ICalObject *)dtstart);
}

/**
 * i_cal_timezone_phase_get_offsetto:
 * @phase: The #ICalTimezonePhase.
 *
 * Get the offsetto of #ICalTimezonePhase. Returns -61 if there is an error.
 *
 * Returns: (transfer none): The offsetto of @phase.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_timezone_phase_get_offsetto (ICalTimezonePhase *phase)
{
	g_return_val_if_fail (phase != NULL && I_CAL_IS_TIMEZONE_PHASE (phase), -61);
	return ((struct icaltimezonephase *)i_cal_object_get_native ((ICalObject *)phase))->offsetto;
}

/**
 * i_cal_timezone_phase_set_offsetto:
 * @phase: The #ICalTimezonePhase.
 * @offsetto: The offsetto.
 *
 * Set the offsetto of #ICalTimezonePhase.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezone_phase_set_offsetto (ICalTimezonePhase *phase, 
                                   gint offsetto)
{
	g_return_if_fail (phase != NULL && I_CAL_IS_TIMEZONE_PHASE (phase));
	((struct icaltimezonephase *)i_cal_object_get_native ((ICalObject *)phase))->offsetto = offsetto;
}

/**
 * i_cal_timezone_phase_get_tzoffsetfrom:
 * @phase: The #ICalTimezonePhase.
 *
 * Get the tzoffsetfrom of #ICalTimezonePhase. Returns -61 if there is an error.
 *
 * Returns: (transfer none): The tzoffsetfrom of @phase.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_timezone_phase_get_tzoffsetfrom (ICalTimezonePhase *phase)
{
	g_return_val_if_fail (phase != NULL && I_CAL_IS_TIMEZONE_PHASE (phase), -61);
	return ((struct icaltimezonephase *)i_cal_object_get_native ((ICalObject *)phase))->tzoffsetfrom;
}

/**
 * i_cal_timezone_phase_set_tzoffsetfrom:
 * @phase: The #ICalTimezonePhase.
 * @tzoffsetfrom: The tzoffsetfrom.
 *
 * Set the tzoffsetfrom of #ICalTimezonePhase.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezone_phase_set_tzoffsetfrom (ICalTimezonePhase *phase, 
                                       gint tzoffsetfrom)
{
	g_return_if_fail (phase != NULL && I_CAL_IS_TIMEZONE_PHASE (phase));
	((struct icaltimezonephase *)i_cal_object_get_native ((ICalObject *)phase))->tzoffsetfrom = tzoffsetfrom;
}

/**
 * i_cal_timezone_phase_get_comment:
 * @phase: The #ICalTimezonePhase.
 *
 * Get the comment of #ICalTimezonePhase.
 *
 * Returns: (transfer none): The comment of @phase.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_timezone_phase_get_comment (ICalTimezonePhase *phase)
{
	g_return_val_if_fail (phase != NULL && I_CAL_IS_TIMEZONE_PHASE (phase), NULL);
	return ((struct icaltimezonephase *)i_cal_object_get_native ((ICalObject *)phase))->comment;
}

/**
 * i_cal_timezone_phase_get_rdate:
 * @phase: The #ICalTimezonePhase.
 *
 * Get the rdate from #ICalTimezonePhase.
 *
 * Returns: (transfer full): The rdate of #ICalTimezonePhase.
 *
 * Since: 1.0
 *
 **/
ICalDatetimeperiodType *
i_cal_timezone_phase_get_rdate (ICalTimezonePhase *phase)
{
	g_return_val_if_fail (phase != NULL && I_CAL_IS_TIMEZONE_PHASE (phase), NULL);
	return i_cal_datetimeperiod_type_new_full (((struct icaltimezonephase *)i_cal_object_get_native ((ICalObject *)phase))->rdate);
}

/**
 * i_cal_timezone_phase_set_rdate:
 * @phase: The #ICalTimezonePhase.
 * @rdate: The rdate of #ICalTimezonePhase.
 *
 * Set the rdate from #ICalTimezonePhase.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezone_phase_set_rdate (ICalTimezonePhase *phase, 
                                ICalDatetimeperiodType *rdate)
{
	g_return_if_fail (phase != NULL && I_CAL_IS_TIMEZONE_PHASE (phase));
    g_return_if_fail (rdate != NULL && I_CAL_IS_DATETIMEPERIOD_TYPE (rdate));
	((struct icaltimezonephase *)i_cal_object_get_native ((ICalObject *)phase))->rdate = *(struct icaldatetimeperiodtype *)i_cal_object_get_native ((ICalObject *)rdate);
}

/**
 * i_cal_timezone_phase_get_rrule:
 * @phase: The #ICalTimezonePhase.
 *
 * Get the rrule of #ICalTimezonePhase.
 *
 * Returns: (transfer none): The rrule of @phase.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_timezone_phase_get_rrule (ICalTimezonePhase *phase)
{
	g_return_val_if_fail (phase != NULL && I_CAL_IS_TIMEZONE_PHASE (phase), NULL);
	return ((struct icaltimezonephase *)i_cal_object_get_native ((ICalObject *)phase))->rrule;
}
