'''
Help message constants. All HELP_* variables are strings shown at the command
line.

@var MSG_CONFIRM_REMOVE: Message displayed to confirm a removal at the command
  line
@type MSG_CONFIRM_REMOVE: string

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2007 IBM Corporation
@license: The BSD License

All rights reserved. This program and the accompanying materials are made 
available under the terms of the BSD license which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/bsd-license.php}
'''
from i18n import _

# command line help strings
HELP_GENERATE = _('generate a template for a new UIE')
HELP_INSTALL = _('install a UIE')
HELP_UNINSTALL = _('uninstall a UIE')
HELP_ASSOCIATE = _('associate a UIE with a profile')
HELP_DISASSOCIATE = _('disassociate a UIE from a profile')
HELP_CREATE_PROFILE = _('create a new user profile')
HELP_REMOVE_PROFILE = _('remove a user profile')
HELP_DUPLICATE_PROFILE = _('duplicate a user profile')
HELP_SHOW = _('show installed UIEs')
HELP_PROFILE = _('profile name')
HELP_SAY = _('output a string using the default device')
HELP_INDEX = _('load order index for the UIE')
HELP_TIER = _('process name with which a Perk should be associated')
HELP_ALL_TIERS = _('flag indicating a Perk should be associated with all apps')
HELP_GLOBAL = _('flag indicating the command should be performed globally')
HELP_LOG_LEVEL = _('level of log messages: %s')
HELP_LOG_CHANNEL = _('channel of log messages, any of: %s')
HELP_LOG_FILENAME = _('filename for simple log output')
HELP_LOG_CONFIG = _('filename for Python logging module configuration')
HELP_NO_INTRO = _('suppress the welcome announcement')
HELP_INIT_PROFILES = _('initialize built-in profiles')
HELP_INIT_GLOBAL = _('initialize installed UIEs with packaged UIEs')
HELP_A11Y = _('Desktop accessibility disabled. Enabling...' \
              '\nPlease logout and run LSR again.')
HELP_NO_A11Y = _('skips check for desktop accessibility')
HELP_NO_BRIDGE = _('prevents UIE windows from becoming accessible')
HELP_EXPORT_PATH = _('prints the path to the LSR package')

# command line messages
MSG_CONFIRM_REMOVE = _('Are you sure you want to remove %s? ') + '(y/n) '