/* canvas-query-cond.h
 *
 * Copyright (C) 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __CANVAS_QUERY_COND__
#define __CANVAS_QUERY_COND__

#include <gnome.h>
#include "canvas-base.h"
#include "query.h"
#include "config.h"

G_BEGIN_DECLS


/* QueryCond item for the canvas.  
 *
 * In addition to the GnomeCanvasGroup and CanvasBase arguments, the following object arguments 
 * are available::
 *
 * name                 type                    read/write      description
 * ------------------------------------------------------------------------------------------
 * query_cond           pointer                 RW              The QueryCond being displayed
 * 
 * 
 * NOTE: the "query_cond" argument is required, even if set to NULL
 * 
 */


#define CANVAS_QUERY_COND_TYPE          (canvas_query_cond_get_type())
#define CANVAS_QUERY_COND(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, canvas_query_cond_get_type(), CanvasQueryCond)
#define CANVAS_QUERY_COND_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, canvas_query_cond_get_type (), CanvasQueryCondClass)
#define IS_CANVAS_QUERY_COND(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, canvas_query_cond_get_type ())


typedef struct _CanvasQueryCond CanvasQueryCond;
typedef struct _CanvasQueryCondClass CanvasQueryCondClass;
typedef struct _CanvasQueryCondPrivate CanvasQueryCondPrivate;

/* struct for the object's data */
struct _CanvasQueryCond
{
	CanvasBase              object;
	CanvasQueryCondPrivate *priv;
};

/* struct for the object's class */
struct _CanvasQueryCondClass
{
	CanvasBaseClass     parent_class;
};

/* generic widget's functions */
guint            canvas_query_cond_get_type   (void);

void             canvas_query_cond_free       (CanvasQueryCond *cqc);

G_END_DECLS

#endif
