/* data-grid.h
 *
 * Copyright (C) 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __DATA_GRID__
#define __DATA_GRID__

#include <gnome.h>
#include <config.h>
#include "query-exec.h"

G_BEGIN_DECLS

#define DATA_GRID_TYPE          (data_grid_get_type())
#define DATA_GRID(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, data_grid_get_type(), DataGrid)
#define DATA_GRID_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, data_grid_get_type (), DataGridClass)
#define IS_DATA_GRID(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, data_grid_get_type ())


typedef struct _DataGrid        DataGrid;
typedef struct _DataGridClass   DataGridClass;
typedef struct _DataGridPrivate DataGridPrivate;


/* struct for the object's data */
struct _DataGrid
{
	GtkVBox          object;

	QueryExec       *qx;

	DataGridPrivate *priv;
};

/* struct for the object's class */
struct _DataGridClass
{
	GtkVBoxClass            parent_class;
	
	void (*action_refresh) (DataGrid * qfm);
	void (*action_insert)  (DataGrid * qfm);
	void (*action_edit)    (DataGrid * qfm, gulong row);
	void (*action_delete)  (DataGrid * qfm, gulong row);
	void (*action_choose)  (DataGrid * qfm, gulong row);

};

/* 
 * Widget management
 */
guint      data_grid_get_type          (void);

GtkWidget *data_grid_new               (QueryExec *qx, gulong numrow);
void       data_grid_refresh           (DataGrid *grid);

/*
 * Getting information
 */



G_END_DECLS

#endif
