/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 8-*- */

/*This file is part of MlView
 *
 *MlView is free software; you can redistribute it and/or modify it under the terms of 
 *the GNU General Public License as published by the Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *MlView is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the GNU General Public License along with MlView; 
 *see the file COPYING. If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *Copyright 2001-2002 Dodji SEKETELI, Gal CHAMOULAUD.
 *http://www.freespiders.org
 */

#ifndef __MLVIEW_ATTRIBUTES_LIST_H__
#define __MLVIEW__ATTRIBUTES_LIST_H__
#include <gnome.h>
#include <libxml/tree.h>
#include "mlview-app-context.h"

G_BEGIN_DECLS

/**
 *@file
 *The declaration of the #MlViewAttributesList class.
 */

#define MLVIEW_ATTRIBUTES_LIST_NULL_PARAMETER -1
#define MLVIEW_ATTRIBUTES_LIST_OK 0
#define MLVIEW_ATTRIBUTES_LIST_NULL -1
#define MLVIEW_ATTRIBUTES_LIST_NULL_XML_NODE -2
#define MLVIEW_ATTRIBUTES_LIST_NULL_NAME_EDIT_ENTRY -3
#define MLVIEW_ATTRIBUTES_LIST_NULL_VALUE_EDIT_ENTRY -4
#define MLVIEW_ATTRIBUTES_LIST_NULL_ATTRIBUTE_VALUE -5
#define MLVIEW_ATTRIBUTES_LIST_NULL_ATTRIBUTE_NAME -6
#define MLVIEW_ATTRIBUTES_LIST_NEW_ATTRIBUTE_FAILED -7
#define MLVIEW_ATTRIBUTES_LIST_READ_ONLY -8

/*
 *compulsory macro to comply with GTK type system.
 */
#define MLVIEW_TYPE_ATTRIBUTES_LIST (mlview_attributes_list_get_type())
#define MLVIEW_ATTRIBUTES_LIST(object) (GTK_CHECK_CAST(object,MLVIEW_TYPE_ATTRIBUTES_LIST,MlViewAttributesList))
#define MLVIEW_ATTRIBUTES_LIST_CLASS(klass) (GTK_CHECK_CLASS_CAST(klass,MLVIEW_TYPE_ATTRIBUTES_LIST,MlViewAttributesListClass))
#define MLVIEW_IS_ATTRIBUTES_LIST(object) (GTK_CHECK_TYPE((object), MLVIEW_TYPE_ATTRIBUTES_LIST))
#define MLVIEW_IS_ATTRIBUTES_LIST_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), MLVIEW_TYPE_ATTRIBUTES_LIST))

enum {
        ATTRIBUTE_NAME_OFFSET,
        ATTRIBUTE_VALUE_OFFSET
};

typedef struct _MlViewAttributesList
MlViewAttributesList;
typedef struct _MlViewAttributesListPrivate
MlViewAttributesListPrivate;
typedef struct _MlViewAttributesListClass
MlViewAttributesListClass;

/**
 *This class is an attributes list editor.
 *It graphically edits the attributes list hold by a given xmlNode.
 *That edition includes adding/deleting/modifying attributes from the list.
 */
struct _MlViewAttributesList {
        /**parent class structure*/
        GtkVBox container;
        /**The private member variables*/
        MlViewAttributesListPrivate *priv;
};

/**
 *The vtable of the MlViewAttributesList class.
 */
struct _MlViewAttributesListClass {
        GtkVBoxClass parent_class;
        /*This class signals */
        void (*edit_state_changed) (MlViewAttributesList
                                    * a_attributes_list,
                                    gpointer a_data);
        void (*attribute_changed) (MlViewAttributesList *
                                   a_attributes_list,
                                   gpointer a_data);
};

guint mlview_attributes_list_get_type (void);

GtkWidget *mlview_attributes_list_new (gchar * a_names_title,
                                       gchar * a_values_title,
                                       MlViewAppContext *a_app_context);

void mlview_attributes_list_set_app_context (MlViewAttributesList * a_attributes,
                                             MlViewAppContext * a_app_context);

void mlview_attributes_list_set_editable (MlViewAttributesList * attributes,
                                          gboolean editable);

void mlview_attributes_list_set_titles (MlViewAttributesList * a_attributes,
                                        gchar * a_names_title,
                                        gchar * a_values_title);
void mlview_attributes_list_set_attribute (MlViewAttributesList * a_attributes,
                                           guint a_offset, const xmlAttrPtr a_xml_attr);

GtkCList *mlview_attributes_list_get_internal_clist (MlViewAttributesList * a_attributes);

gint mlview_attributes_list_add_attribute_to_view (MlViewAttributesList * a_attributes,
                                                   const xmlAttrPtr a_xml_attr);

gint mlview_attributes_list_create_attribute (MlViewAttributesList * a_attributes);

void mlview_attributes_list_remove_attribute (MlViewAttributesList * a_attributes,
                                              const guint a_attr_offset);

void mlview_attributes_list_get_attribute (MlViewAttributesList * a_attributes,
                                           const guint a_offset,
                                           xmlAttrPtr * a_xml_attr_ptr);

void mlview_attributes_list_edit_xml_attributes (MlViewAttributesList * a_attributes_list,
                                                 const xmlNodePtr a_xml_node);
void mlview_attributes_list_clear (MlViewAttributesList * a_attributes);

G_END_DECLS
#endif
