/* -*- Mode: C; indent-tabs-mode:nil; c-basic-offset: 8-*- */
/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *See COPYRIGHT file for copyright information.
 */
#ifndef __MLVIEW_SOURCE_VIEW_H
#define __MLVIEW_SOURCE_VIEW_H

#include "mlview-view-adapter.h"
#include "mlview-xml-document.h"

G_BEGIN_DECLS

#define MLVIEW_TYPE_SOURCE_VIEW (mlview_source_view_get_type ())
#define MLVIEW_SOURCE_VIEW(widget) (G_TYPE_CHECK_INSTANCE_CAST ((widget), MLVIEW_TYPE_SOURCE_VIEW, MlViewSourceView))
#define MLVIEW_SOURCE_VIEW_CLASS(widget) (G_TYPE_CHECK_CLASS_CAST ((widget), MLVIEW_TYPE_SOURCE_VIEW, MlViewSourceViewClass))
#define MLVIEW_IS_SOURCE_VIEW(widget) (G_TYPE_CHECK_INSTANCE_TYPE ((widget),MLVIEW_TYPE_SOURCE_VIEW))
#define MLVIEW_IS_SOURCE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MLVIEW_TYPE_SOURCE_VIEW))

typedef struct _MlViewSourceView MlViewSourceView ;
typedef struct _MlViewSourceViewClass MlViewSourceViewClass ;
typedef struct _MlViewSourceViewPriv MlViewSourceViewPriv ;

struct _MlViewSourceView {
	MlViewViewAdapter view ;
	MlViewSourceViewPriv *priv ;
} ;

struct _MlViewSourceViewClass {
	MlViewViewAdapterClass parent_class ;
	/*signal default handlers*/
} ;

GType mlview_source_view_get_type (void) ;

GtkWidget * mlview_source_view_new (MlViewXMLDocument *a_doc, 
		                    const gchar *a_name,
				    MlViewAppContext *a_app_ctxt) ;

enum MlViewStatus mlview_source_view_construct (MlViewSourceView *a_this,
		                                MlViewXMLDocument *a_doc,
						const gchar *a_view_name,
						MlViewAppContext *a_app_context) ;

enum MlViewStatus mlview_source_view_set_default_options (MlViewSourceView *a_this) ;


MlViewAppContext * mlview_source_view_get_application_context (MlViewSourceView *);

GtkUIManager * mlview_source_view_get_ui_manager (MlViewSourceView *a_this) ;

enum MlViewStatus mlview_source_view_is_there_an_opened_tag (MlViewSourceView *a_this,
							     gboolean *a_answer)  ;

enum MlViewStatus mlview_source_view_close_currently_opened_tag 
					(MlViewSourceView *a_this,
					 gboolean *a_has_been_closed) ; 

G_END_DECLS

#endif /*__MLVIEW_SOURCE_VIEW_H*/
