#ifndef XSERVER_CLIENT_PROTOCOL_H
#define XSERVER_CLIENT_PROTOCOL_H

#ifdef  __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

struct wl_client;
struct wl_resource;

struct xserver;

extern const struct wl_interface xserver_interface;

struct xserver_listener {
	/**
	 * client - (none)
	 * @fd: (none)
	 */
	void (*client)(void *data,
		       struct xserver *xserver,
		       int32_t fd);
	/**
	 * listen_socket - (none)
	 * @fd: (none)
	 */
	void (*listen_socket)(void *data,
			      struct xserver *xserver,
			      int32_t fd);
};

static inline int
xserver_add_listener(struct xserver *xserver,
		     const struct xserver_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) xserver,
				     (void (**)(void)) listener, data);
}

#define XSERVER_SET_WINDOW_ID	0

static inline void
xserver_set_user_data(struct xserver *xserver, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) xserver, user_data);
}

static inline void *
xserver_get_user_data(struct xserver *xserver)
{
	return wl_proxy_get_user_data((struct wl_proxy *) xserver);
}

static inline void
xserver_destroy(struct xserver *xserver)
{
	wl_proxy_destroy((struct wl_proxy *) xserver);
}

static inline void
xserver_set_window_id(struct xserver *xserver, struct wl_surface *surface, uint32_t id)
{
	wl_proxy_marshal((struct wl_proxy *) xserver,
			 XSERVER_SET_WINDOW_ID, surface, id);
}

#ifdef  __cplusplus
}
#endif

#endif
