/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

/* 
 * Copyright (C) 2002, Thomas Vander Stichele
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Thomas Vander Stichele <thomas at apestaart dot org>
 */

/* audio-info-test.c - test AudioInfo object
 */

#include <config.h>
#include <libgnomevfs/gnome-vfs.h>

#include "audio-info.h"

int
main (int argc, char *argv[])
{
	AudioInfo *info;
	int current_arg = 1;
	
	gst_init (&argc, &argv);

	if (argc < 2)
	{
		g_print ("You need to supply a URI for a file to test\n");
		return -1;
	}

	if (!gnome_vfs_init ())
		g_error ("Could not initialize gnomevfs !");
	while (current_arg < argc)
	{
		gchar *file = g_strdup (argv[current_arg]);
		g_print ("file: %s\n", file);
		g_print ("type: %s\n", gnome_vfs_get_mime_type (file));
		info = audio_info_new (file);
		g_assert (info);
		audio_info_update (info);
		g_free (file);
		if (info)
		{
			g_print ("type: %s\n", info->type);
			g_print ("length: %d\n", info->length);
			if (info->channels) 
				g_print ("channels: %d\n", info->channels);
			if (info->samplerate) 
				g_print ("samplerate: %d\n", info->samplerate);
			if (info->bitrate) 
				g_print ("bitrate: %d\n", info->bitrate);
			audio_info_free (info);
		}
		++current_arg;
	}
}
