/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __ACACHE_H__
#define __ACACHE_H__

#include <glib.h>

void       acache_init              (void);

void       acache_shutdown          (void);

gint       acache_expire            (void);

gint       acache_expire_all        (void);

void       acache_file_checkin      (const gchar * message_id);

void       acache_file_checkout     (const gchar * message_id);

gchar*     acache_get_filename      (const gchar * message_id);

void       acache_delete            (const gchar * message_id);

gboolean   acache_has_message       (const gchar * message_id);

gchar*     acache_get_message       (const gchar * message_id);

void       acache_set_message       (const gchar * message_id,
                                     const gchar * message);

#endif /* __ACACHE_H__ */
