/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <config.h>

#include <stdarg.h>
#include <stdio.h>
#include <time.h>

#include <pthread.h>

#include "debug.h"
#include "util.h"

unsigned long debug_level = 0;

void
set_debug_level (unsigned long level)
{
	debug_level = level;
}

void
debug_printf (const gchar   * filename,
              int             line_num,
              gulong          flag,
              const gchar   * fmt,
              ...)
{
	char timebuf[64];
	gchar * string;
	const gchar * prefix;
	time_t now_time_t;
	va_list args;
	struct tm now_tm;

	g_return_if_fail (fmt != NULL);

	/* get prefix */
	if (flag&DEBUG_QUEUE) prefix="QUEUE";
	else if (flag&DEBUG_SOCKET_INPUT) prefix="SOCKET INPUT";
	else if (flag&DEBUG_SOCKET_OUTPUT) prefix="SOCKET OUTPUT";
	else if (flag&DEBUG_DECODE) prefix="DECODE";
	else if (flag&DEBUG_ACACHE) prefix="ACACHE";
	else if (flag&DEBUG_LOCK) prefix="LOCK";
	else if (flag&DEBUG_DB) prefix="DATABASE";
	else if (flag&DEBUG_PAN_OBJECT) prefix="PAN OBJECT";
	else {prefix="FOO";}

	va_start (args, fmt);
	string = g_strdup_vprintf (fmt, args);
	va_end (args);

	time (&now_time_t);
	gmtime_r (&now_time_t, &now_tm);
	strftime (timebuf, sizeof(timebuf), "%H:%M:%S", &now_tm);

	printf ("(%s:%d)(thread %d)(time %s) %s: %s\n",
		filename,
		line_num,
		(int)pthread_self(),
		timebuf,
		prefix,
		string);
	fflush (NULL);

	g_free (string);
}

