/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __MESSAGE_WINDOW_H__
#define __MESSAGE_WINDOW_H__

#include "article.h"

typedef enum
{
	NNTP_READ,
	NNTP_POST,
	NNTP_REPLY,
	EMAIL_REPLY,
	EMAIL_AND_POST_REPLY,
	EMAIL_FORWARD,
	EDIT_ORIGINAL
}
MessageWindowType;

typedef struct
{
	GtkWidget * window; /* GnomeApp */
	GtkWidget * appbar; /* GnomeAppBar */

	GtkWidget * read_info_pane;

	GtkWidget * from;
	GtkWidget * custom_headers_text;
	GtkWidget * user_agent_tb;
	GtkWidget * organization;
	GtkWidget * newsgroups;
	GtkWidget * users;
	GtkWidget * subject;
        GtkWidget * followup_to;
        GtkWidget * reply_to;
	GtkWidget * body;

	/* Attachment */
	GtkWidget * filename;
	GtkWidget * lines;
	GtkWidget * lines_per_part;
	GtkWidget * parts;

	Article * article;
	MessageWindowType type;
}
MessageWindow;

extern gboolean use_message_window_always;

void message_followup_reply_window  (GtkWidget * widget);

void message_followup_window        (GtkWidget   * widget);

void message_reply_window           (GtkWidget   * widget);

void message_forward_window         (GtkWidget   * widget);

void message_edit_window            (GtkWidget   * widget,
                                     Article     * article);

void message_read_window            (GtkWidget   * widget,
                                     Article     * article);

void message_reply_external         (GtkWidget   * widget,
                                     Article     * article);

void message_post_window            (GtkWidget   * widget);

void update_body_pane_nolock        (GtkWidget   * body_widget,
                                     const gchar * body,
				     gboolean      mute_quotes);

void update_body_pane               (GtkWidget   * body_widget,
                                     const gchar * body,
				     gboolean      mute_quotes);

void message_window_new             (Article           * article,
                                     MessageWindowType   type);

/**
***
**/


#endif
