/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __SERVER_H__
#define __SERVER_H__

#include <time.h>
#include <glib.h>
#include "pan-callback.h"
#include "pan-object.h"

#define SERVER(a) ((Server*)a)

typedef struct
{
	/* Parent */
	PanObject parent;

	/*Callbacks*/
	PanCallback* online_status_changed;  /* obj arg is 1 or 0 */

	/*Fields*/
	guint groups_dirty         : 1;  /* grouplist needs saving on exit */
	guint posting              : 1;  /* is posting allowed? */
	guint gen_msgid            : 1;
	guint need_auth            : 1;  /* need authorization ? */
	guint online               : 1;  /* is this server online? */
	guint online_prompted      : 1;  /* true if user's been asked to go online for some tasks. */
	guint reserve_nonleech     : 1;
	gint8 max_connections;           /* max connections to server */
        gint16 idle_secs_before_timeout;
	gint16 port;	                 /* #, NNTP usually 119, SMTP usually 25 */
	time_t last_newgroup_list_time;
	gchar * address;                 /* server net address */
	gchar * name;	                 /* pretty name, i.e. Erols */
	gchar * username;                /* auth username */
	gchar * password;                /* auth password */
	GPtrArray * groups;              /* groups owned by this server */
	GStringChunk * chunk;            /* const string chunk for use by the owned groups. */
}
Server;

#define INTERNAL_SERVER_NAME "folders"

/**
***  PROTECTED
**/

void       server_constructor            (Server*, PanObjectDestructor);

void       server_destructor             (PanObject*);

/**
***  PUBLIC - Life Cycle
**/

Server*    server_new (void);

gboolean   server_has_group              (const Server*, const char* groupname);

/**
***  PUBLIC - Newsrc
**/

void       server_import_newsrc_dialog   (Server*);

void       server_export_newsrc_dialog   (Server*);

/**
***  PUBLIC - Online
**/

void       server_set_online             (Server*, gboolean);

void       server_prompt_to_go_online    (Server*);

/**
***  PUBLIC - Server Groups
**/

struct _Group;

void       server_add_groups             (Server              * server,
                                          struct _Group      ** groups,
                                          int                   group_qty,
                                          GPtrArray           * fillme_used,
                                          GPtrArray           * fillme_not_used);

gboolean   server_add_group              (Server * server, struct _Group * group);

void       server_remove_group           (Server * server, struct _Group * group);

void       server_destroy_group          (Server * server, struct _Group * group);

/**
***  General Server Util
**/

void       server_add_new_server         (Server * server);

void       server_init                   (void);

void       server_shutdown               (void);

void       server_menu_update            (void);

Server*    server_get_by_name            (const char* servername);

const gchar* server_chunk_string (Server * server, const gchar * chunkme);

#endif /* __SERVER_H__ */
