/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef TASK_DECODE__H
#define TASK_DECODE__H

#include "task.h"
#include "group.h"


/**
***  TASK DECODE DECLARATION
**/

#define TASK_DECODE(obj) ((TaskDecode*)obj)

typedef struct
{
	/* Parent */
	Task         item;

	/* private */
	Group      * group;
	GSList     * articles;
	gboolean     open;
	gchar      * readable_name;
	gchar      * path;
	gchar      * filename;
}
TaskDecode;


/**
***   PUBLIC
**/

PanObject* task_decode_new (Group        * group,
			    const char   * readable_name_for_description,
			    const char   * save_path_or_null,
			    const char   * save_filename_or_null,
			    const GSList * articles,
			    gboolean       open);

void task_decode_validate_and_queue_or_self_destruct (TaskDecode*, int queue_index);

#endif
