/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef TASK_GROUPLIST__H
#define TASK_GROUPLIST__H

#include "task.h"
#include "group.h"

#define TASK_GROUPLIST(a) ((TaskGroupList *)a)

typedef enum
{
	GROUPLIST_ALL,
	GROUPLIST_NEW
}
GrouplistDownloadType;

typedef struct
{
	/* parent */
	Task                      item;

	/* private */
	Server                  * server;
	GrouplistDownloadType     download_type;
	GPtrArray               * groups;
	gboolean                  got_list;
}
TaskGroupList;

PanObject* task_grouplist_new (Server                  * server,
                               gboolean                  high_priority,
                               GrouplistDownloadType     type);

#endif
