/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __TASK_BODY__H__
#define __TASK_BODY__H__

#include "task.h"
#include "group.h"
#include "article.h"

#define TASK_BODY(obj) ((TaskBody*)(obj))

typedef struct
{
	/* parent class */
	Task task;

	/* private, passed in ctor */
	guint open_in_new_window : 1;
	Article * article;
	MessageWindowType message_window_type;
}
TaskBody;

/**
***  PUBLIC
**/

PanObject*  task_body_new_defaults   (Article           * article);

PanObject*  task_body_new            (Article           * article,
                                      gboolean            open_in_new_window,
                                      MessageWindowType   message_window_type);


#endif /* __TASK_BODY__H__ */
