#ifndef PAGE_H			// -*- c++ -*-
#define PAGE_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "group.h"
#include <list> 

struct Guide { // a guide-line
  bool is_horizontal;
  float position;
  Guide(bool is_horizontal_, float position_):
    is_horizontal(is_horizontal_), position( position_)
  {}
  Guide(const xmlpp::Element& node);
};

class Document;

class Page: public Group {
public:
  Page(Document&);
  Page(const xmlpp::Element& node, Document&, const FileContext &context);
  ~Page();
  
  xmlpp::Element *save(xmlpp::Element& parent_node,
		       const FileContext &context);
  void print(std::ostream &out, bool grayscale = false);
  std::string get_name(); // return page number if no name
  float get_width() const;
  float get_height() const;
  float get_xpos() const;
  float get_ypos() const;

  int get_page_num() const; // ask document what the page number is
  
  void addObject(Pagent* obj);
  
  void child_ready_to_draw(Pagent *pagent);
  static SigC::Signal1<void, Pagent*> ready_to_draw_page_signal;

  void select_all(bool select);	// false for select none

  /** Find the Page containing a specific Pagent. */
  static Page& containing(Pagent& obj);
  /** Find the Page containing a specific Pagent. */
  static const Page& containing(const Pagent& obj);
  
protected:
  friend class Document;	/// \todo not like this, anyway ...
  Document &document;

public:				/// \todo eh, no ...
  typedef std::list<Guide> Guides;
  Guides guides;

private:
  // Undefined ctors, avoid defaults
  Page(const Page&);
  Page();
  void operator = (const Page&);
};

#endif
