///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "loader.h"
#include "fileerrors.h"
#include "imageframe.h"
#include "rasterframe.h"
#include "textframe.h"

Pagent *load(const xmlpp::Element& node, Group *parent,
	     const FileContext& context)
{
  std::string name = node.get_name();
  if(name == "frame") { 
    const xmlpp::Attribute* type_attr = node.get_attribute("type");
    if(!type_attr)
      throw Error::Read("No type attribute for frame");
    const std::string type = type_attr->get_value();

    // create according to type string:
    if(type == "group")
      return new Group(parent, node, context);
    else if(type == "image")
      return new ImageFrame(parent, node, context);
    else if(type == "raster")
      return new RasterFrame(parent, node, context);
    else if(type == "text")
      return new TextFrame(parent, node);
    else
      throw Error::Read("Unknown frame type: \"" + type + "\".");
  } else {
    throw Error::Read("Expected a <frame> but got a <" + name + ">.");
  }
}
