///
// Copyright (C) 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "groupviewent.h"
#include "pptcore.h"
#include <gdkmm.h>
#include <functional>

class SubView : public View {
public:
  SubView(View& p, const Matrix& m) : parent(p), matrix(m) {}
  
  Glib::RefPtr<Gdk::Drawable> get_win() { return parent.get_win(); }
  Glib::RefPtr<Gdk::GC> get_gc() { return parent.get_gc(); }
  
  gdouble get_scrres() const {
    const Matrix inv = matrix.inv();
    return dist(inv.transform(Vector(parent.get_scrres(), 0)),
		inv.transform(Vector(0,0)));
  }
  // transforming lengths only make sense if the axes are 
  // scaled by the same amount
  float pt2scr(float pt) const {
    return parent.pt2scr(dist(matrix.transform(Vector(pt, 0)),
			      matrix.transform(Vector(0,0))));
  }
  Gdk::Point pt2scr(const Vector& pt) const {
    return parent.pt2scr(matrix.transform(pt));
  }
  Vector scr2pt(const Gdk::Point& scr) const {
    return matrix.inv().transform(parent.scr2pt(scr));
  }
  float scr2pt(float scr) const { // untested code!
    return dist(scr2pt(Gdk::Point(int(scr + 0.5), 0)), 
		scr2pt(Gdk::Point(0, 0)));
  }
  Glib::RefPtr<const Gdk::Pixmap> get_wait_pixmap() const {
    return parent.get_wait_pixmap();
  }
  Glib::RefPtr<const Gdk::Pixmap> get_missing_pixmap() const {
    return parent.get_missing_pixmap();
  }
  Glib::RefPtr<const Gdk::Pixmap> get_broken_pixmap() const {
    return parent.get_broken_pixmap();
  }
  const Gdk::Color &get_color(Color::Id color) const { 
    return parent.get_color(color); 
  }
  SigC::Connection connect_zoom_change(SigC::Slot1<void, float> slot) {
    return parent.connect_zoom_change(slot);
  }
private:
  View& parent;
  const Matrix& matrix;
};

GroupViewent::GroupViewent(View& view, const FrameRef groupframe)
  : Viewent(view), subview(new SubView(view, groupframe->get_matrix())),
    frame(groupframe),
    groupcon(frame->group_changed_signal.connect
	     (SigC::hide<Pagent*>(slot(*this, &GroupViewent::group_changed))))
{
  // Create the initial content, just as if it was added after this object.
  group_changed();
}

GroupViewent::~GroupViewent() {
  /// \todo delete subview; but make sure its not used first
}

bool GroupViewent::draw_content() {
  // reverse order, this is correct at least for Page
  bool ok = true;
  for(ChildVec::reverse_iterator i = childvec.rbegin(); 
      i != childvec.rend(); 
      i++)
    ok = (*i)->draw_content() && ok;
  return ok;
}

void GroupViewent::group_changed() {
  ChildVec newchilds;
  for(Group::ChildVec::const_iterator i = frame->pbegin();
      i != frame->pend();
      ++i) {
    ChildVec::const_iterator old;
    for(old = childvec.begin(); old != childvec.end(); ++old) {
      if((*old)->samePagent(*i))
	break;
    }
    if(old != childvec.end())
      newchilds.push_back(*old);
    else
      newchilds.push_back(core.getMeta((*i)->getTypeName())->
			  create_viewent(*subview, **i));
  }
  swap(childvec, newchilds);
}
