#ifndef PPT_GROUPVIEWENT_H	// -*- C++ -*-
#define PPT_GROUPVIEWENT_H
///
// Copyright (C) 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "viewent.h"
#include "document/group.h"
#include <vector>

class GroupViewent : public Viewent {
  typedef Group* FrameRef;
  typedef Viewent::Ref ChildRef;
  typedef std::vector<ChildRef> ChildVec;
public:
  GroupViewent(View& view, const FrameRef groupframe);
  ~GroupViewent();
  
  bool draw_content();
  
protected:
  const Pagent* get_frame() const { return frame; }
  
private:
  /** Callback for group_chagned_signal */
  void group_changed();

  View* subview;
  FrameRef frame;
  SigC::Connection groupcon;

protected:  		     	/// \todo maybe private?
  ChildVec childvec;
};

#endif
