#ifndef PIXBUFTRANSFORMATOR_H	// -*- c++ -*-
#define PIXBUFTRANSFORMATOR_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "view.h"
#include "util/matrix.h"
#include <gdkmm/pixbuf.h>

class PixbufTransformator : public SigC::Object {
public:
  PixbufTransformator(Glib::RefPtr<const Gdk::Pixbuf> src,
		      const View& v,  const Matrix& m);
  ~PixbufTransformator();
  
  Glib::RefPtr<Gdk::Pixbuf> getPixbuf() const { return buf; }
  bool isDone() const { return is_done; }
  bool workLine();

private:
  Glib::RefPtr<Gdk::Pixbuf> buf;
  Glib::RefPtr<const Gdk::Pixbuf> srcpix;
  gint max_x, min_x, max_y, min_y;
  gint cur_y;
  bool is_done;
  Vector lstart, d_pix, d_line;
  
  // Undefined
  PixbufTransformator();
  PixbufTransformator(const PixbufTransformator&);
  void operator=(const PixbufTransformator&);
};

#endif
