///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef PDF_H
#define PDF_H

#include <vector>
#include <glibmm/ustring.h>

namespace PDF {
  
  typedef long bytecount; // number of bytes written
  typedef long refnum; 
  typedef long generation; 

  class Document;

  class XRefs;
  class Page;

  class Part{
  public:
    Part(Document *document):document_(document), dummy(4711) {}
    virtual ~Part();
    virtual bytecount write(std::ostream *out, bool binary=true, 
			    bytecount offset=0)
    {offset_=offset; return offset;}
    void set_offset(bytecount offset) {offset_=offset;}    
    bytecount get_offset() const {return offset_;}

  protected:
    // Remember a dynamically allocated part that is to be deleted when 
    // this part is deleted:
    template<class AnyPart>
    AnyPart *manage(AnyPart *part)
    {managed.push_back(dynamic_cast<Part*>(part)); return part;}

    Document *document_;

  private:
    typedef std::vector<Part*> Managed;
    Managed managed;
    bytecount offset_;
    const int dummy; // prevent using default constructor

    Part(const Part&);
    Part();
    void operator = (const Part&);
  };

  class Document: public Part {
  public:
    Document();
    void add_page(int width, int height);
    void selectfont(int size);
    void moveto(float xpos, float ypos);
    void rmoveto(float dx, float dy);
    void show(Glib::ustring s);
    void whitespace(float width);
    bytecount write(std::ostream *out, bool binary=true, 
		    bytecount offset=0);
    XRefs *get_xrefs() const {return xrefs;}

  private:
    typedef std::vector<Page*> Pages;
    Pages pages;
    XRefs *xrefs;
  };

};

#endif
