#ifndef FILEWATCHER_H		// -*- c++ -*-
#define FILEWATCHER_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include <sigc++/sigc++.h>
#include <string>

/**
 * Monitor a file for changes.
 */
class FileWatcher: public SigC::Object {
public:
  /**
   * \param filename Reference to string containing file to watch. The
   * string may be changed at any time.
   * \ param interval Interval in milliseconds between checks.
   */
  FileWatcher(const std::string &filename, int interval = 100);
  virtual ~FileWatcher();

  /**
   * Signal emitted every time a change is detected.
   */
  SigC::Signal0<void> modified_signal;

protected:
  const std::string &file;
  std::string last_file;
  time_t last_time;
  SigC::Connection connection;
  bool check_file();

private:
  // Undefined ctors, avoid defaults
  FileWatcher(const FileWatcher&);
  FileWatcher();
  void operator = (const FileWatcher&);

};

#endif
