#ifndef UNDO_H			// -*- c++ -*-
#define UNDO_H
///
// Copyright (C) 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include <list>

namespace undo {

  class Action {
  public:
    Action() : save_mark(false) {}
    virtual ~Action() {}
    virtual void undo() const = 0;
    virtual void redo() const = 0;
    virtual void set_save_mark(bool _save_mark = true) {save_mark=_save_mark;}
    bool get_save_mark() {return save_mark;}
  private:
    bool save_mark;
  };

  class Undoable {
  public:
    Undoable(int _max = -1) : max(_max) {}
    virtual ~Undoable();

    // basic functions
    virtual void push_action(Action *action);
    virtual void undo(bool push_redo = true);
    virtual void redo(bool push_undo = true);
    virtual void set_save_mark(); // mark object as saved

    // examine the stack
    int get_undo_count() const;
    int get_redo_count() const;
    bool has_been_saved() const;
    const Action *get_action(int index = 0); 
    // Index increases with age. Negative indices point to redo actions.

    // set maximum undo stack size
    virtual void set_max(int _max);

    // override this to be notified when the stack has been changed
    virtual void on_stack_change() {}

  private:
    int max;
    typedef std::list<Action*> Stack;
    Stack stack, redo_stack;

    void clear_redos();
    void trim();
  };
  
};

#endif
